/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.region;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.flag.GroupedMutableRegionFlag;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.member.FlagMemberGroup;
import org.empirewar.orbis.member.Member;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.GlobalRegion;
import org.empirewar.orbis.region.RegionType;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.registry.RegistryResolvable;
import org.jetbrains.annotations.NotNull;

public sealed class Region
implements RegionQuery.Flag.Queryable,
Comparable<Region>,
RegistryResolvable<String>
permits GlobalRegion {
    public static final MapCodec<Region> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Region::name), (App)Codec.STRING.listOf().fieldOf("parents").forGetter(r -> r.parents().stream().map(Region::name).toList()), (App)Member.CODEC.listOf().fieldOf("members").forGetter(r -> r.members().stream().toList()), (App)MutableRegionFlag.TYPE_CODEC.listOf().fieldOf("flags").forGetter(r -> r.flags.values().stream().toList()), (App)Area.CODEC.fieldOf("area").forGetter(Region::area), (App)Codec.INT.fieldOf("priority").forGetter(Region::priority)).apply((Applicative)instance, Region::new));
    private final String name;
    private final Set<Region> parents;
    private final Set<Member> members;
    protected final Map<Key, MutableRegionFlag<?>> flags;
    private final Area area;
    private int priority;

    public Region(String name, Area area) {
        this.name = name;
        this.parents = new HashSet<Region>();
        this.members = new HashSet<Member>();
        this.flags = new HashMap();
        this.area = area;
        this.priority = 2;
    }

    private Region(String name, List<String> parents, List<Member> members, List<MutableRegionFlag<?>> flags, Area area, int priority) {
        this.name = name;
        this.parents = new HashSet<Region>();
        parents.forEach(parentName -> {
            OrbisAPI.get().logger().info("Region {} waiting for region parent {}", (Object)name, parentName);
            OrbisRegistries.REGIONS.resolve(parentName, this::addParent);
        });
        this.members = new HashSet<Member>(members);
        this.flags = new HashMap();
        flags.forEach(mu -> this.flags.put(mu.key(), (MutableRegionFlag<?>)mu));
        this.area = area;
        this.priority = priority;
    }

    public String name() {
        return this.name;
    }

    public Set<Region> parents() {
        return Set.copyOf(this.parents);
    }

    public void addParent(Region region) {
        if (region.equals(this)) {
            throw new IllegalArgumentException("Cannot add parent of self!");
        }
        if (region.parents.contains(this)) {
            throw new IllegalArgumentException("Cannot have a parent loop!");
        }
        if (this.parents.stream().anyMatch(p -> p.parents.contains(region))) {
            throw new IllegalArgumentException("Cannot have a parent loop!");
        }
        this.parents.add(region);
    }

    public void removeParent(Region region) {
        this.parents.remove(region);
    }

    public Set<Member> members() {
        return Set.copyOf(this.members);
    }

    public void addMember(Member member) {
        this.members.add(member);
    }

    public void removeMember(Member member) {
        this.members.remove(member);
    }

    public Area area() {
        return this.area;
    }

    public int priority() {
        return this.priority;
    }

    public void priority(int priority) {
        Preconditions.checkState((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be positive");
        this.priority = priority;
    }

    public <T> MutableRegionFlag<T> addFlag(RegistryRegionFlag<T> flag) {
        MutableRegionFlag<T> mutable = flag.asMutable();
        this.flags.put(flag.key(), mutable);
        return mutable;
    }

    public <T> GroupedMutableRegionFlag<T> addGroupedFlag(RegistryRegionFlag<T> flag, Set<FlagMemberGroup> groups) {
        GroupedMutableRegionFlag<T> grouped = flag.asGrouped();
        this.flags.put(flag.key(), grouped);
        groups.forEach(grouped::addGroup);
        return grouped;
    }

    public boolean removeFlag(RegistryRegionFlag<?> flag) {
        return this.flags.remove(flag.key()) == null;
    }

    public boolean hasFlag(RegistryRegionFlag<?> flag) {
        return this.flags.containsKey(flag.key());
    }

    public <T> Optional<MutableRegionFlag<T>> getFlag(RegistryRegionFlag<T> flag) {
        return Optional.ofNullable(this.flags.get(flag.key()));
    }

    public <T> void setFlag(RegistryRegionFlag<T> flag, T value) {
        MutableRegionFlag<T> mu = this.getFlag(flag).orElseThrow(() -> new IllegalArgumentException("Region '" + this.name + "' does not have a flag by key '" + flag.key().asString() + "'!"));
        mu.setValue(value);
    }

    @Override
    public <FR> RegionQuery.Result<Optional<FR>, RegionQuery.Flag<FR>> query(RegionQuery.Flag<FR> flag) {
        Optional<MutableRegionFlag<FR>> foundFlag = this.getFlag(flag.flag());
        Optional<UUID> player = flag.player();
        Member playerMember = player.flatMap(uuid -> this.members.stream().filter(member -> member.checkMember((UUID)uuid)).findAny()).orElse(null);
        Optional foundValue = foundFlag.flatMap(mutableRegionFlag -> {
            if (player.isPresent() && mutableRegionFlag instanceof GroupedMutableRegionFlag) {
                GroupedMutableRegionFlag group = (GroupedMutableRegionFlag)mutableRegionFlag;
                if (playerMember == null && !group.groups().contains((Object)FlagMemberGroup.NONMEMBER)) {
                    return Optional.empty();
                }
                if (playerMember != null && !group.groups().contains((Object)FlagMemberGroup.MEMBER)) {
                    return Optional.empty();
                }
            }
            return Optional.of(mutableRegionFlag.getValue());
        }).or(() -> this.parents.stream().sorted(Comparator.reverseOrder()).map(r -> r.query(flag)).map(RegionQuery.Result::result).findAny().orElse(Optional.empty()));
        return flag.resultBuilder().query(flag).result(foundValue).build();
    }

    public boolean isGlobal() {
        return this instanceof GlobalRegion;
    }

    public RegionType<?> getType() {
        return RegionType.NORMAL;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("flags", this.flags).add("area", (Object)this.area).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region region = (Region)o;
        return Objects.equals(this.name(), region.name());
    }

    public int hashCode() {
        return Objects.hashCode(this.name());
    }

    @Override
    public int compareTo(@NotNull Region o) {
        return Integer.compare(this.priority, o.priority());
    }

    @Override
    public String key() {
        return this.name;
    }
}

