/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegionFlagType;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.member.MemberType;
import org.empirewar.orbis.member.PlayerMember;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.region.RegionType;
import org.empirewar.orbis.registry.KeyOrbisRegistry;
import org.empirewar.orbis.registry.OrbisRegistry;
import org.empirewar.orbis.registry.RegistryResolvable;
import org.empirewar.orbis.registry.ResolvableStringOrbisRegistry;
import org.empirewar.orbis.registry.lifecycle.RegistryLifecycles;

public final class OrbisRegistries {
    private static final Map<Key, Supplier<?>> DEFAULT_ENTRIES = Maps.newLinkedHashMap();
    public static final ResolvableStringOrbisRegistry<Region> REGIONS = OrbisRegistries.createStringResolvable(Key.key((String)"orbis", (String)"regions"), r -> null);
    public static final KeyOrbisRegistry<RegistryRegionFlag<?>> FLAGS = OrbisRegistries.create(Key.key((String)"orbis", (String)"flags"), r -> DefaultFlags.CAN_BREAK);
    public static final KeyOrbisRegistry<RegionFlagType<?>> FLAG_TYPE = OrbisRegistries.create(Key.key((String)"orbis", (String)"flag_type"), r -> {
        RegionFlagType<MutableRegionFlag<?>> type = RegionFlagType.MUTABLE;
        r.setLifecycle(RegistryLifecycles.frozen());
        return type;
    });
    public static final KeyOrbisRegistry<AreaType<?>> AREA_TYPE = OrbisRegistries.create(Key.key((String)"orbis", (String)"area_type"), r -> {
        AreaType<CuboidArea> type = AreaType.CUBOID;
        r.setLifecycle(RegistryLifecycles.frozen());
        return type;
    });
    public static final KeyOrbisRegistry<RegionType<?>> REGION_TYPE = OrbisRegistries.create(Key.key((String)"orbis", (String)"region_type"), r -> {
        RegionType<Region> type = RegionType.NORMAL;
        r.setLifecycle(RegistryLifecycles.frozen());
        return type;
    });
    public static final KeyOrbisRegistry<MemberType<?>> MEMBER_TYPE = OrbisRegistries.create(Key.key((String)"orbis", (String)"member_type"), r -> {
        MemberType<PlayerMember> type = MemberType.PLAYER;
        r.setLifecycle(RegistryLifecycles.frozen());
        return type;
    });

    private static <T> KeyOrbisRegistry<T> create(Key key, Initializer<T, Key> initializer) {
        KeyOrbisRegistry registry = new KeyOrbisRegistry(key);
        DEFAULT_ENTRIES.put(key, () -> initializer.run(registry));
        return registry;
    }

    private static <T extends RegistryResolvable<String>> ResolvableStringOrbisRegistry<T> createStringResolvable(Key key, Initializer<T, String> initializer) {
        ResolvableStringOrbisRegistry registry = new ResolvableStringOrbisRegistry(key);
        DEFAULT_ENTRIES.put(key, () -> initializer.run(registry));
        return registry;
    }

    public static void initialize() {
        DEFAULT_ENTRIES.forEach((id, initializer) -> initializer.get());
        DEFAULT_ENTRIES.clear();
    }

    @FunctionalInterface
    static interface Initializer<T, K> {
        public T run(OrbisRegistry<T, K> var1);
    }
}

