/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.util.Optional;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.datafixer.OrbisDataFixes;
import org.empirewar.orbis.datafixer.TypeReferences;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.region.RegionType;
import org.empirewar.orbis.registry.OrbisRegistries;

public final class RegionAdapter
implements JsonSerializer<Region>,
JsonDeserializer<Region> {
    public JsonElement serialize(Region region, Type typeOfSrc, JsonSerializationContext context) {
        Codec dispatch = OrbisRegistries.REGION_TYPE.getCodec().dispatch(Region::getType, RegionType::codec);
        Optional result = dispatch.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)region).resultOrPartial(msg -> OrbisAPI.get().logger().error("Error saving region: {}", msg));
        return result.map(OrbisDataFixes::updateFixerVersion).orElse(null);
    }

    public Region deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        JsonElement fixed = OrbisDataFixes.fix(TypeReferences.REGION, object);
        Codec dispatch = OrbisRegistries.REGION_TYPE.getCodec().dispatch(Region::getType, RegionType::codec);
        Optional result = dispatch.parse((DynamicOps)JsonOps.INSTANCE, (Object)fixed).resultOrPartial(msg -> OrbisAPI.get().logger().error("Error loading region: {}", msg));
        return result.orElse(null);
    }
}

