/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import org.joml.Vector2i;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public interface ExtraCodecs {
    public static final Codec<Vector3ic> VEC_3I = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(Vector3ic::x), (App)Codec.INT.fieldOf("y").forGetter(Vector3ic::y), (App)Codec.INT.fieldOf("z").forGetter(Vector3ic::z)).apply((Applicative)instance, Vector3i::new));
    public static final Codec<Vector2i> VEC_2I = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(Vector2i::x), (App)Codec.INT.fieldOf("y").forGetter(Vector2i::y)).apply((Applicative)instance, Vector2i::new));
    public static final Codec<Key> KEY = Codec.STRING.comapFlatMap(ExtraCodecs::validateKey, Key::asString).stable();
    public static final Codec<UUID> STRING_UUID = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> "Invalid UUID " + string + ": " + e.getMessage());
        }
    }, UUID::toString);
    public static final Codec<Component> COMPONENT = Codec.STRING.comapFlatMap(json -> DataResult.success((Object)JSONComponentSerializer.json().deserialize(json)), component -> (String)JSONComponentSerializer.json().serialize(component));

    private static DataResult<Key> validateKey(String id) {
        return DataResult.success((Object)Key.key((String)id));
    }
}

