/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.player.PlayerOrbisSession;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.sponge.libs.cloud.annotations.Argument;
import org.empirewar.orbis.sponge.libs.cloud.annotations.Command;
import org.empirewar.orbis.sponge.libs.cloud.annotations.Permission;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;

@Permission(value={"orbis.manage"})
public final class SelectionCommand {
    @Command(value="orbis select|selection|sel <type>")
    public void onSelectType(PlayerOrbisSession session, @Argument(value="type") AreaType<?> type) {
        Orbis orbis = OrbisAPI.get();
        orbis.selectionManager().get(session.getUuid()).ifPresentOrElse(selection -> selection.setSelectionType(type), () -> orbis.selectionManager().add(session.getUuid(), new Selection(type)));
        Key typeKey = (Key)OrbisRegistries.AREA_TYPE.getKey(type).orElseThrow();
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_SET_TYPE.arguments(new ComponentLike[]{Component.text((String)typeKey.asString())})));
    }

    @Command(value="orbis select|selection|sel clear")
    public void onClear(PlayerOrbisSession session) {
        Orbis orbis = OrbisAPI.get();
        orbis.selectionManager().get(session.getUuid()).ifPresentOrElse(selection -> {
            selection.clear();
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_CLEARED));
            orbis.selectionManager().remove(session.getUuid());
        }, () -> session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_NOT_ACTIVE)));
    }
}

