/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.member;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.member.Member;
import org.empirewar.orbis.member.MemberType;

public final class PermissionMember
extends Member {
    public static MapCodec<PermissionMember> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("permission").forGetter(PermissionMember::permission)).apply((Applicative)instance, PermissionMember::new));
    private final String permission;

    public PermissionMember(String permission) {
        this.permission = permission;
    }

    public String permission() {
        return this.permission;
    }

    @Override
    public boolean checkMember(UUID member) {
        return OrbisAPI.get().hasPermission(member, this.permission);
    }

    @Override
    public MemberType<?> getType() {
        return MemberType.PERMISSION;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PermissionMember)) {
            return false;
        }
        PermissionMember that = (PermissionMember)object;
        return Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hashCode(this.permission);
    }
}

