/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.sponge.command.SpongeCommands;
import org.empirewar.orbis.sponge.key.SpongeDataKeys;
import org.empirewar.orbis.sponge.listener.BlockActionListener;
import org.empirewar.orbis.sponge.listener.ConnectionListener;
import org.empirewar.orbis.sponge.listener.DamageEntityListener;
import org.empirewar.orbis.sponge.listener.InteractEntityListener;
import org.empirewar.orbis.sponge.listener.MovementListener;
import org.empirewar.orbis.sponge.listener.RegionMessagesListener;
import org.empirewar.orbis.sponge.selection.SelectionListener;
import org.empirewar.orbis.sponge.task.SpongeRegionVisualiserTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.RegisterDataEvent;
import org.spongepowered.api.event.lifecycle.StartedEngineEvent;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="orbis")
public class OrbisSponge
extends OrbisPlatform {
    private final Logger logger = LoggerFactory.getLogger((String)"orbis");
    private final PluginContainer pluginContainer;
    @ConfigDir(sharedRoot=false)
    private final Path dataFolder;

    public PluginContainer pluginContainer() {
        return this.pluginContainer;
    }

    public static OrbisSponge get() {
        return (OrbisSponge)OrbisAPI.get();
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    @Inject
    public OrbisSponge(PluginContainer pluginContainer, @ConfigDir(sharedRoot=false) Path dataFolder) {
        this.pluginContainer = pluginContainer;
        this.dataFolder = dataFolder;
        this.load();
    }

    @Listener
    public void onRegisterCommands(RegisterCommandEvent<Command.Parameterized> event) {
        new SpongeCommands(this, event.registryHolder());
    }

    @Listener
    public void onServerStarting(StartingEngineEvent<Server> event) {
        this.registerListeners();
        try {
            this.loadRegions();
        }
        catch (IOException e) {
            this.logger().error("Error loading regions", (Throwable)e);
        }
    }

    @Listener
    public void onServerStarted(StartedEngineEvent<Server> event) {
        SpongeDataKeys.initialized();
        Sponge.server().worldManager().worlds().forEach(w -> this.loadWorld((Key)w.key(), w.uniqueId()));
        Sponge.server().scheduler().submit(Task.builder().execute((Runnable)new SpongeRegionVisualiserTask(this)).interval(Ticks.of((long)20L)).plugin(this.pluginContainer).build());
    }

    @Listener
    public void onServerStopping(StoppingEngineEvent<Server> event) {
        try {
            this.saveRegions();
        }
        catch (IOException e) {
            this.logger().error("Error saving regions", (Throwable)e);
        }
    }

    @Listener
    private void onRegisterData(RegisterDataEvent event) {
        SpongeDataKeys.register(event);
    }

    @Listener
    public void onWorldLoad(LoadWorldEvent event) {
        ServerWorld world = event.world();
        this.loadWorld((Key)world.key(), world.uniqueId());
    }

    @Listener(order=Order.LATE)
    public void onWorldUnload(UnloadWorldEvent event) {
        ServerWorld world = event.world();
        this.saveWorld((Key)world.key(), world.uniqueId());
    }

    private void registerListeners() {
        EventManager eventManager = Sponge.eventManager();
        eventManager.registerListeners(this.pluginContainer, (Object)new BlockActionListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new InteractEntityListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new MovementListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new ConnectionListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new SelectionListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new DamageEntityListener(this), MethodHandles.lookup());
        eventManager.registerListeners(this.pluginContainer, (Object)new RegionMessagesListener(this), MethodHandles.lookup());
    }

    @Override
    public Key getPlayerWorld(UUID player) {
        return ((ServerPlayer)Sponge.server().player(player).orElseThrow()).world().key();
    }

    @Override
    public boolean hasPermission(UUID player, String permission) {
        ServerPlayer sponge = Sponge.server().player(player).orElse(null);
        if (sponge == null) {
            return false;
        }
        return sponge.hasPermission(permission);
    }

    @Override
    public Path dataFolder() {
        return this.dataFolder;
    }

    @Override
    protected InputStream getResourceAsStream(String path) {
        return (InputStream)this.pluginContainer.openResource(path).orElseThrow();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }
}

