/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.caffeine;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.empirewar.orbis.sponge.libs.caffeine.DisabledFuture;
import org.empirewar.orbis.sponge.libs.caffeine.Scheduler;

final class GuardedScheduler
implements Scheduler,
Serializable {
    private static final System.Logger logger = System.getLogger(GuardedScheduler.class.getName());
    private static final long serialVersionUID = 1L;
    final Scheduler delegate;

    GuardedScheduler(Scheduler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Future<?> schedule(Executor executor, Runnable command, long delay, TimeUnit unit) {
        try {
            Future<?> future = this.delegate.schedule(executor, command, delay, unit);
            return future == null ? DisabledFuture.INSTANCE : future;
        }
        catch (Throwable t2) {
            logger.log(System.Logger.Level.WARNING, "Exception thrown by scheduler; discarded task", t2);
            return DisabledFuture.INSTANCE;
        }
    }
}

