/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.annotations.string;

import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.annotations.string.StringProcessor;

public class PatternReplacingStringProcessor
implements StringProcessor {
    private final Pattern pattern;
    private final Function<MatchResult, String> replacementProvider;

    public PatternReplacingStringProcessor(@NonNull Pattern pattern, @NonNull Function<@NonNull MatchResult, @Nullable String> replacementProvider) {
        this.pattern = pattern;
        this.replacementProvider = replacementProvider;
    }

    @Override
    public @NonNull String processString(@NonNull String input) {
        Matcher matcher = this.pattern.matcher(input);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = this.replacementProvider.apply(matcher);
            matcher.appendReplacement(stringBuffer, replacement == null ? "$0" : replacement);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

