/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.injection;

import java.util.Objects;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.util.annotation.AnnotationAccessor;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface ParameterInjector<C, T> {
    @API(status=API.Status.STABLE)
    public static <C, T> @NonNull ParameterInjector<C, T> constantInjector(@NonNull T value) {
        return new ConstantInjector(value);
    }

    public @Nullable T create(@NonNull CommandContext<C> var1, @NonNull AnnotationAccessor var2);

    public static final class ConstantInjector<C, T>
    implements ParameterInjector<C, T> {
        private final T value;

        private ConstantInjector(@NonNull T value) {
            this.value = value;
        }

        @Override
        public @NonNull T create(@NonNull CommandContext<C> context, @NonNull AnnotationAccessor annotationAccessor) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantInjector that = (ConstantInjector)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConstantInjector{value=" + this.value + '}';
        }
    }
}

