/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.execution.preprocessor.CommandPreprocessingContext;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionMapper;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionProcessor;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.Suggestions;

@API(status=API.Status.INTERNAL, consumers={"org.empirewar.orbis.sponge.libs.cloud.*"})
public final class SuggestionContext<C, S extends Suggestion> {
    private final List<S> suggestions = new ArrayList<S>();
    private final CommandPreprocessingContext<C> preprocessingContext;
    private final SuggestionMapper<S> mapper;
    private final SuggestionProcessor<C> processor;
    private final CommandContext<C> commandContext;

    public SuggestionContext(@NonNull SuggestionProcessor<C> processor, @NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput, @NonNull SuggestionMapper<S> mapper) {
        this.processor = processor;
        this.commandContext = commandContext;
        this.preprocessingContext = CommandPreprocessingContext.of(this.commandContext, commandInput);
        this.mapper = mapper;
    }

    public @NonNull Suggestions<C, S> makeSuggestions() {
        Stream<Suggestion> processedStream;
        Stream<Suggestion> stream = this.suggestions.stream();
        List<Object> list = stream == (processedStream = this.processor.process(this.preprocessingContext, stream)) ? Collections.unmodifiableList(this.suggestions) : Collections.unmodifiableList(processedStream.peek(obj -> Objects.requireNonNull(obj, "suggestion")).map(this.mapper::map).collect(Collectors.toList()));
        return Suggestions.create(this.commandContext, list, this.preprocessingContext.commandInput());
    }

    public @NonNull CommandContext<C> commandContext() {
        return this.commandContext;
    }

    public void addSuggestions(@NonNull Iterable<? extends @NonNull Suggestion> suggestions) {
        suggestions.forEach(this::addSuggestion);
    }

    public void addSuggestion(@NonNull Suggestion suggestion) {
        Objects.requireNonNull(suggestion, "suggestion");
        this.suggestions.add(this.mapper.map(suggestion));
    }
}

