/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data;

import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;

public final class MinecraftTime {
    private static final MinecraftTime ZERO = new MinecraftTime(0L);
    private final long ticks;

    public static @NonNull MinecraftTime of(long ticks) {
        return ticks == 0L ? ZERO : new MinecraftTime(ticks);
    }

    public static @NonNull MinecraftTime of(long amount, @NonNull TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return new MinecraftTime(Math.round((double)amount / 50.0 * (double)unit.getDuration().toMillis()));
    }

    public static @NonNull MinecraftTime of(long amount, @NonNull TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return amount == 0L ? ZERO : new MinecraftTime(TimeUnit.MILLISECONDS.convert(amount, unit) / 50L);
    }

    MinecraftTime(long ticks) {
        this.ticks = ticks;
    }

    public int ticks() {
        return (int)this.ticks;
    }

    public long ticksLong() {
        return this.ticks;
    }

    public long convertTo(@NonNull TemporalUnit unit) {
        return this.ticks * 50L / unit.getDuration().toMillis();
    }

    public long convertTo(@NonNull TimeUnit unit) {
        return unit.convert(this.ticks * 50L, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.ticks == ((MinecraftTime)other).ticks;
    }

    public int hashCode() {
        return Objects.hash(this.ticks);
    }

    public String toString() {
        return Long.toString(this.ticks);
    }
}

