/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.CommandManager;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.CloudBrigadierManager;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.parser.WrappedBrigadierParser;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.ModdedParserParameters;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.annotation.specifier.Center;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.Coordinates;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.Message;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MinecraftTime;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MultipleEntitySelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MultiplePlayerSelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.SingleEntitySelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.SinglePlayerSelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser.RegistryEntryParser;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser.TeamParser;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser.VanillaArgumentParsers;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserParameters;
import org.empirewar.orbis.sponge.libs.cloud.parser.standard.UUIDParser;
import org.slf4j.Logger;

@API(status=API.Status.INTERNAL)
public final class ModdedParserMappings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MOD_PUBLIC_STATIC_FINAL = 25;

    private ModdedParserMappings() {
    }

    public static <C, S> void register(@NonNull CommandManager<C> manager, @NonNull CloudBrigadierManager<C, S> brigadier) {
        ModdedParserMappings.registerRegistryEntryMappings(manager, brigadier);
        brigadier.registerMapping(new TypeToken<TeamParser<C>>(){}, builder -> builder.toConstant((ArgumentType<?>)TeamArgument.team()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(PlayerTeam.class), params -> new TeamParser());
        brigadier.registerMapping(new TypeToken<UUIDParser<C>>(){}, builder -> builder.toConstant((ArgumentType<?>)UuidArgument.uuid()));
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, ChatFormatting.class, ColorArgument.color());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, CompoundTag.class, CompoundTagArgument.compoundTag());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, Tag.class, NbtTagArgument.nbtTag());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, NbtPathArgument.NbtPath.class, NbtPathArgument.nbtPath());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, ObjectiveCriteria.class, ObjectiveCriteriaArgument.criteria());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, OperationArgument.Operation.class, OperationArgument.operation());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, AngleArgument.SingleAngle.class, AngleArgument.angle());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, new TypeToken<EnumSet<Direction.Axis>>(){}, SwizzleArgument.swizzle());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, ResourceLocation.class, ResourceLocationArgument.id());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, EntityAnchorArgument.Anchor.class, EntityAnchorArgument.anchor());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, MinMaxBounds.Ints.class, RangeArgument.intRange());
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, MinMaxBounds.Doubles.class, RangeArgument.floatRange());
        ModdedParserMappings.registerContextualNativeParserSupplier(manager, ParticleOptions.class, ParticleArgument::particle);
        ModdedParserMappings.registerContextualNativeParserSupplier(manager, ItemInput.class, ItemArgument::item);
        ModdedParserMappings.registerContextualNativeParserSupplier(manager, BlockPredicateArgument.Result.class, BlockPredicateArgument::blockPredicate);
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, MessageArgument.Message.class, MessageArgument.message());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MinecraftTime.class), params -> VanillaArgumentParsers.timeParser().parser());
    }

    public static <C> void registerServer(CommandManager<C> manager) {
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Message.class), params -> VanillaArgumentParsers.messageParser().parser());
        manager.parserRegistry().registerAnnotationMapper(Center.class, (annotation, type) -> ParserParameters.single(ModdedParserParameters.CENTER_INTEGERS, true));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Coordinates.class), params -> VanillaArgumentParsers.vec3Parser(params.get(ModdedParserParameters.CENTER_INTEGERS, false)).parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Coordinates.CoordinatesXZ.class), params -> VanillaArgumentParsers.vec2Parser(params.get(ModdedParserParameters.CENTER_INTEGERS, false)).parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Coordinates.BlockCoordinates.class), params -> VanillaArgumentParsers.blockPosParser().parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Coordinates.ColumnCoordinates.class), params -> VanillaArgumentParsers.columnPosParser().parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(SinglePlayerSelector.class), params -> VanillaArgumentParsers.singlePlayerSelectorParser().parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), params -> VanillaArgumentParsers.multiplePlayerSelectorParser().parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(SingleEntitySelector.class), params -> VanillaArgumentParsers.singleEntitySelectorParser().parser());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), params -> VanillaArgumentParsers.multipleEntitySelectorParser().parser());
    }

    private static <C, S> void registerRegistryEntryMappings(@NonNull CommandManager<C> manager, @NonNull CloudBrigadierManager<C, S> brigadier) {
        brigadier.registerMapping(new TypeToken<RegistryEntryParser<C, ?>>(){}, builder -> builder.to(argument -> ResourceKeyArgument.key(argument.registryKey())));
        HashSet<Class> seenClasses = new HashSet<Class>();
        seenClasses.add(ResourceLocation.class);
        seenClasses.add(Codec.class);
        seenClasses.add(String.class);
        for (Field field : Registries.class.getDeclaredFields()) {
            ResourceKey key;
            Type generic;
            if ((field.getModifiers() & 0x19) != 25 || !field.getType().equals(ResourceKey.class) || !((generic = field.getGenericType()) instanceof ParameterizedType)) continue;
            Type registryType = ((ParameterizedType)generic).getActualTypeArguments()[0];
            while (registryType instanceof WildcardType) {
                registryType = ((WildcardType)registryType).getUpperBounds()[0];
            }
            if (!(registryType instanceof ParameterizedType)) continue;
            try {
                key = (ResourceKey)field.get(null);
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn("Failed to access value of registry key in field {} of type {}", new Object[]{field.getName(), generic, ex});
                continue;
            }
            Type valueType = ((ParameterizedType)registryType).getActualTypeArguments()[0];
            if (seenClasses.contains(GenericTypeReflector.erase((Type)valueType))) {
                LOGGER.debug("Encountered duplicate type in registry {}: type {}", (Object)key, (Object)valueType);
                continue;
            }
            seenClasses.add(GenericTypeReflector.erase((Type)valueType));
            manager.parserRegistry().registerParserSupplier(TypeToken.get((Type)valueType), params -> new RegistryEntryParser(key));
        }
    }

    public static <C, T> void registerContextualNativeParserSupplier(@NonNull CommandManager<C> manager, @NonNull Class<T> type, @NonNull Function<CommandBuildContext, @NonNull ArgumentType<T>> argument) {
        manager.parserRegistry().registerParserSupplier(TypeToken.get(type), params -> VanillaArgumentParsers.contextualParser(argument, type).parser());
    }

    public static <C, T> void registerConstantNativeParserSupplier(@NonNull CommandManager<C> manager, @NonNull Class<T> type, @NonNull ArgumentType<T> argument) {
        ModdedParserMappings.registerConstantNativeParserSupplier(manager, TypeToken.get(type), argument);
    }

    public static <C, T> void registerConstantNativeParserSupplier(@NonNull CommandManager<C> manager, @NonNull TypeToken<T> type, @NonNull ArgumentType<T> argument) {
        manager.parserRegistry().registerParserSupplier(type, params -> new WrappedBrigadierParser(argument));
    }
}

