/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.scores.PlayerTeam;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.ModdedCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.caption.ModdedCaptionKeys;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser.SidedArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.BlockingSuggestionProvider;

public final class TeamParser<C>
extends SidedArgumentParser<C, String, PlayerTeam>
implements BlockingSuggestionProvider.Strings<C> {
    public static <C> @NonNull ParserDescriptor<C, PlayerTeam> teamParser() {
        return ParserDescriptor.of(new TeamParser<C>(), PlayerTeam.class);
    }

    public static <C> @NonNull CommandComponent.Builder<C, PlayerTeam> teamComponent() {
        return CommandComponent.builder().parser(TeamParser.teamParser());
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return new ArrayList<String>(commandContext.get(ModdedCommandContextKeys.SHARED_SUGGESTION_PROVIDER).getAllTeams());
    }

    @Override
    protected  @NonNull ArgumentParser.FutureArgumentParser<C, String> intermediateParser() {
        return (ctx, commandInput) -> ArgumentParseResult.successFuture(commandInput.readString());
    }

    @Override
    protected @NonNull CompletableFuture<@NonNull ArgumentParseResult<PlayerTeam>> resolveClient(@NonNull CommandContext<C> context, @NonNull String value) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            throw new IllegalStateException();
        }
        PlayerTeam result = connection.getLevel().getScoreboard().getPlayerTeam(value);
        if (result == null) {
            return ArgumentParseResult.failureFuture(new UnknownTeamException(context, value));
        }
        return ArgumentParseResult.successFuture(result);
    }

    @Override
    protected @NonNull CompletableFuture<@NonNull ArgumentParseResult<PlayerTeam>> resolveServer(@NonNull CommandContext<C> context, @NonNull String value) {
        CommandSourceStack source = (CommandSourceStack)context.get(ModdedCommandContextKeys.SHARED_SUGGESTION_PROVIDER);
        PlayerTeam result = source.getLevel().getScoreboard().getPlayerTeam(value);
        if (result == null) {
            return ArgumentParseResult.failureFuture(new UnknownTeamException(context, value));
        }
        return ArgumentParseResult.successFuture(result);
    }

    public static final class UnknownTeamException
    extends ParserException {
        UnknownTeamException(@NonNull CommandContext<?> context, @NonNull String input) {
            super(TeamParser.class, context, ModdedCaptionKeys.ARGUMENT_PARSE_FAILURE_TEAM_UNKNOWN, CaptionVariable.of("input", input));
        }
    }
}

