/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.parser.WrappedBrigadierParser;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.ModdedCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.Coordinates;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.Message;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MinecraftTime;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MultipleEntitySelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.MultiplePlayerSelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.SingleEntitySelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.data.SinglePlayerSelector;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal.ContextualArgumentTypeProvider;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal.EntitySelectorAccess;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;

public final class VanillaArgumentParsers {
    private VanillaArgumentParsers() {
    }

    public static <C, V> @NonNull ParserDescriptor<C, V> contextualParser(@NonNull Function<CommandBuildContext, ArgumentType<V>> factory, @NonNull Class<V> valueType) {
        return ParserDescriptor.of(new WrappedBrigadierParser(new ContextualArgumentTypeProvider<V>(factory)), valueType);
    }

    public static <C> @NonNull ParserDescriptor<C, ItemInput> itemInput() {
        return VanillaArgumentParsers.contextualParser(ItemArgument::item, ItemInput.class);
    }

    public static <C> @NonNull ParserDescriptor<C, MinecraftTime> timeParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<Integer>)TimeArgument.time()).flatMapSuccess((ctx, val) -> ArgumentParseResult.successFuture(MinecraftTime.of(val.intValue())));
        return ParserDescriptor.of(parser, MinecraftTime.class);
    }

    public static <C> @NonNull ParserDescriptor<C, Coordinates.BlockCoordinates> blockPosParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<net.minecraft.commands.arguments.coordinates.Coordinates>)BlockPosArgument.blockPos()).flatMapSuccess(VanillaArgumentParsers::mapToCoordinates);
        return ParserDescriptor.of(parser, Coordinates.BlockCoordinates.class);
    }

    public static <C> @NonNull ParserDescriptor<C, Coordinates.ColumnCoordinates> columnPosParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<net.minecraft.commands.arguments.coordinates.Coordinates>)ColumnPosArgument.columnPos()).flatMapSuccess(VanillaArgumentParsers::mapToCoordinates);
        return ParserDescriptor.of(parser, Coordinates.ColumnCoordinates.class);
    }

    public static <C> @NonNull ParserDescriptor<C, Coordinates.CoordinatesXZ> vec2Parser(boolean centerIntegers) {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<net.minecraft.commands.arguments.coordinates.Coordinates>)new Vec2Argument(centerIntegers)).flatMapSuccess(VanillaArgumentParsers::mapToCoordinates);
        return ParserDescriptor.of(parser, Coordinates.CoordinatesXZ.class);
    }

    public static <C> @NonNull ParserDescriptor<C, Coordinates> vec3Parser(boolean centerIntegers) {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<net.minecraft.commands.arguments.coordinates.Coordinates>)Vec3Argument.vec3((boolean)centerIntegers)).flatMapSuccess(VanillaArgumentParsers::mapToCoordinates);
        return ParserDescriptor.of(parser, Coordinates.class);
    }

    private static <C, O extends Coordinates> @NonNull CompletableFuture<@NonNull ArgumentParseResult<O>> mapToCoordinates(@NonNull CommandContext<C> ctx, @NonNull net.minecraft.commands.arguments.coordinates.Coordinates posArgument) {
        return VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> ArgumentParseResult.successFuture(new CoordinatesImpl((CommandSourceStack)serverCommandSource, posArgument)));
    }

    public static <C> @NonNull ParserDescriptor<C, SinglePlayerSelector> singlePlayerSelectorParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<EntitySelector>)EntityArgument.player()).flatMapSuccess((ctx, entitySelector) -> VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> VanillaArgumentParsers.handleCommandSyntaxExceptionAsFailure(() -> ArgumentParseResult.success(new SinglePlayerSelectorImpl(((EntitySelectorAccess)entitySelector).inputString(), (EntitySelector)entitySelector, entitySelector.findSinglePlayer(serverCommandSource))))));
        return ParserDescriptor.of(parser, SinglePlayerSelector.class);
    }

    public static <C> @NonNull ParserDescriptor<C, MultiplePlayerSelector> multiplePlayerSelectorParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<EntitySelector>)EntityArgument.players()).flatMapSuccess((ctx, entitySelector) -> VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> VanillaArgumentParsers.handleCommandSyntaxExceptionAsFailure(() -> ArgumentParseResult.success(new MultiplePlayerSelectorImpl(((EntitySelectorAccess)entitySelector).inputString(), (EntitySelector)entitySelector, entitySelector.findPlayers(serverCommandSource))))));
        return ParserDescriptor.of(parser, MultiplePlayerSelector.class);
    }

    public static <C> @NonNull ParserDescriptor<C, SingleEntitySelector> singleEntitySelectorParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<EntitySelector>)EntityArgument.entity()).flatMapSuccess((ctx, entitySelector) -> VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> VanillaArgumentParsers.handleCommandSyntaxExceptionAsFailure(() -> ArgumentParseResult.success(new SingleEntitySelectorImpl(((EntitySelectorAccess)entitySelector).inputString(), (EntitySelector)entitySelector, entitySelector.findSingleEntity(serverCommandSource))))));
        return ParserDescriptor.of(parser, SingleEntitySelector.class);
    }

    public static <C> @NonNull ParserDescriptor<C, MultipleEntitySelector> multipleEntitySelectorParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<EntitySelector>)EntityArgument.entities()).flatMapSuccess((ctx, entitySelector) -> VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> VanillaArgumentParsers.handleCommandSyntaxExceptionAsFailure(() -> ArgumentParseResult.success(new MultipleEntitySelectorImpl(((EntitySelectorAccess)entitySelector).inputString(), (EntitySelector)entitySelector, Collections.unmodifiableCollection(entitySelector.findEntities(serverCommandSource)))))));
        return ParserDescriptor.of(parser, MultipleEntitySelector.class);
    }

    public static <C> @NonNull ParserDescriptor<C, Message> messageParser() {
        ArgumentParser.FutureArgumentParser parser = new WrappedBrigadierParser((ArgumentType<MessageArgument.Message>)MessageArgument.message()).flatMapSuccess((ctx, format) -> VanillaArgumentParsers.requireServer(ctx, serverCommandSource -> VanillaArgumentParsers.handleCommandSyntaxExceptionAsFailure(() -> ArgumentParseResult.success(MessageImpl.from(serverCommandSource, format, true)))));
        return ParserDescriptor.of(parser, Message.class);
    }

    private static <O> @NonNull CompletableFuture<ArgumentParseResult<O>> handleCommandSyntaxExceptionAsFailure(@NonNull CommandSyntaxExceptionThrowingParseResultSupplier<O> resultSupplier) {
        try {
            return CompletableFuture.completedFuture(resultSupplier.result());
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failureFuture(ex);
        }
    }

    private static @NonNull IllegalStateException serverOnly() {
        return new IllegalStateException("This command argument type is server-only.");
    }

    private static <C, O> @NonNull CompletableFuture<ArgumentParseResult<O>> requireServer(@NonNull CommandContext<C> context, @NonNull Function<CommandSourceStack, CompletableFuture<ArgumentParseResult<O>>> resultFunction) {
        SharedSuggestionProvider nativeSource = context.get(ModdedCommandContextKeys.SHARED_SUGGESTION_PROVIDER);
        if (!(nativeSource instanceof CommandSourceStack) || VanillaArgumentParsers.isClientSource(nativeSource)) {
            return ArgumentParseResult.failureFuture(VanillaArgumentParsers.serverOnly());
        }
        return resultFunction.apply((CommandSourceStack)nativeSource);
    }

    @API(status=API.Status.INTERNAL)
    public static boolean isClientSource(SharedSuggestionProvider sharedSuggestionProvider) {
        return !sharedSuggestionProvider.getClass().equals(CommandSourceStack.class);
    }

    @FunctionalInterface
    private static interface CommandSyntaxExceptionThrowingParseResultSupplier<O> {
        public @NonNull ArgumentParseResult<O> result() throws CommandSyntaxException;
    }

    private record MessageImpl(Collection<Entity> mentionedEntities, Component contents) implements Message
    {
        static MessageImpl from(@NonNull CommandSourceStack source, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull MessageArgument.Message message, boolean useSelectors) throws CommandSyntaxException {
            Set<Entity> entities;
            Component contents = message.toComponent(source, useSelectors);
            MessageArgument.Part[] selectors = message.parts();
            if (!useSelectors || selectors.length == 0) {
                entities = Collections.emptySet();
            } else {
                entities = new HashSet();
                for (MessageArgument.Part selector : selectors) {
                    entities.addAll(selector.selector().findEntities(source));
                }
            }
            return new MessageImpl(entities, contents);
        }
    }

    private record MultipleEntitySelectorImpl(String inputString, EntitySelector selector, Collection<Entity> values) implements MultipleEntitySelector
    {
    }

    private static final class SingleEntitySelectorImpl
    extends Record
    implements SingleEntitySelector {
        private final String inputString;
        private final EntitySelector selector;
        private final Entity single;

        private SingleEntitySelectorImpl(String inputString, EntitySelector selector, Entity single) {
            this.inputString = inputString;
            this.selector = selector;
            this.single = single;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SingleEntitySelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SingleEntitySelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SingleEntitySelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this, o);
        }

        @Override
        public String inputString() {
            return this.inputString;
        }

        @Override
        public EntitySelector selector() {
            return this.selector;
        }

        @Override
        public Entity single() {
            return this.single;
        }
    }

    private record MultiplePlayerSelectorImpl(String inputString, EntitySelector selector, Collection<ServerPlayer> values) implements MultiplePlayerSelector
    {
    }

    private static final class SinglePlayerSelectorImpl
    extends Record
    implements SinglePlayerSelector {
        private final String inputString;
        private final EntitySelector selector;
        private final ServerPlayer single;

        private SinglePlayerSelectorImpl(String inputString, EntitySelector selector, ServerPlayer single) {
            this.inputString = inputString;
            this.selector = selector;
            this.single = single;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SinglePlayerSelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SinglePlayerSelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SinglePlayerSelectorImpl.class, "inputString;selector;single", "inputString", "selector", "single"}, this, o);
        }

        @Override
        public String inputString() {
            return this.inputString;
        }

        @Override
        public EntitySelector selector() {
            return this.selector;
        }

        @Override
        public ServerPlayer single() {
            return this.single;
        }
    }

    private record CoordinatesImpl(CommandSourceStack source, net.minecraft.commands.arguments.coordinates.Coordinates wrappedCoordinates) implements Coordinates,
    Coordinates.CoordinatesXZ,
    Coordinates.BlockCoordinates,
    Coordinates.ColumnCoordinates
    {
        @Override
        public @NonNull Vec3 position() {
            return this.wrappedCoordinates.getPosition(this.source);
        }

        @Override
        public @NonNull BlockPos blockPos() {
            return BlockPos.containing((Position)this.position());
        }

        @Override
        public boolean isXRelative() {
            return this.wrappedCoordinates.isXRelative();
        }

        @Override
        public boolean isYRelative() {
            return this.wrappedCoordinates.isYRelative();
        }

        @Override
        public boolean isZRelative() {
            return this.wrappedCoordinates.isZRelative();
        }
    }
}

