/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.permission;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.permission.PermissionLevelResult;
import org.empirewar.orbis.sponge.libs.cloud.permission.Permission;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@API(status=API.Status.INTERNAL, consumers={"org.empirewar.orbis.sponge.libs.cloud.*"})
@Generated(from="PermissionLevelResult", generator="Immutables")
@Immutable
final class PermissionLevelResultImpl
implements PermissionLevelResult {
    private final boolean allowed;
    private final @NonNull Permission permission;
    private final int requiredPermissionLevel;

    private PermissionLevelResultImpl(boolean allowed, @NonNull Permission permission, int requiredPermissionLevel) {
        this.allowed = allowed;
        this.permission = Objects.requireNonNull(permission, "permission");
        this.requiredPermissionLevel = requiredPermissionLevel;
    }

    private PermissionLevelResultImpl(PermissionLevelResultImpl original, boolean allowed, @NonNull Permission permission, int requiredPermissionLevel) {
        this.allowed = allowed;
        this.permission = permission;
        this.requiredPermissionLevel = requiredPermissionLevel;
    }

    @Override
    public boolean allowed() {
        return this.allowed;
    }

    @Override
    public @NonNull Permission permission() {
        return this.permission;
    }

    @Override
    public int requiredPermissionLevel() {
        return this.requiredPermissionLevel;
    }

    public final PermissionLevelResultImpl withAllowed(boolean value) {
        if (this.allowed == value) {
            return this;
        }
        return new PermissionLevelResultImpl(this, value, this.permission, this.requiredPermissionLevel);
    }

    public final PermissionLevelResultImpl withPermission(@NonNull Permission value) {
        if (this.permission == value) {
            return this;
        }
        @NonNull Permission newValue = Objects.requireNonNull(value, "permission");
        return new PermissionLevelResultImpl(this, this.allowed, newValue, this.requiredPermissionLevel);
    }

    public final PermissionLevelResultImpl withRequiredPermissionLevel(int value) {
        if (this.requiredPermissionLevel == value) {
            return this;
        }
        return new PermissionLevelResultImpl(this, this.allowed, this.permission, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PermissionLevelResultImpl && this.equalsByValue((PermissionLevelResultImpl)another);
    }

    private boolean equalsByValue(PermissionLevelResultImpl another) {
        return this.allowed == another.allowed && this.permission.equals(another.permission) && this.requiredPermissionLevel == another.requiredPermissionLevel;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Boolean.hashCode(this.allowed);
        h2 += (h2 << 5) + this.permission.hashCode();
        h2 += (h2 << 5) + this.requiredPermissionLevel;
        return h2;
    }

    public String toString() {
        return "PermissionLevelResult{allowed=" + this.allowed + ", permission=" + String.valueOf(this.permission) + ", requiredPermissionLevel=" + this.requiredPermissionLevel + "}";
    }

    public static PermissionLevelResultImpl of(boolean allowed, @NonNull Permission permission, int requiredPermissionLevel) {
        return new PermissionLevelResultImpl(allowed, permission, requiredPermissionLevel);
    }

    public static PermissionLevelResultImpl copyOf(PermissionLevelResult instance) {
        if (instance instanceof PermissionLevelResultImpl) {
            return (PermissionLevelResultImpl)instance;
        }
        return PermissionLevelResultImpl.of(instance.allowed(), instance.permission(), instance.requiredPermissionLevel());
    }
}

