/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.parser;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.MappedArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionProvider;

@API(status=API.Status.INTERNAL)
public final class MappedArgumentParserImpl<C, I, O>
implements MappedArgumentParser<C, I, O>,
ArgumentParser.FutureArgumentParser<C, O> {
    private final ArgumentParser<C, I> base;
    private final MappedArgumentParser.Mapper<C, I, O> mapper;

    MappedArgumentParserImpl(ArgumentParser<C, I> base, MappedArgumentParser.Mapper<C, I, O> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    @Override
    public @NonNull ArgumentParser<C, I> baseParser() {
        return this.base;
    }

    @Override
    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<O>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        return this.base.parseFuture(commandContext, commandInput).thenCompose(result -> this.mapper.map(commandContext, (ArgumentParseResult<I>)result));
    }

    @Override
    public @NonNull SuggestionProvider<C> suggestionProvider() {
        return this.base.suggestionProvider();
    }

    @Override
    public <O1> @NonNull ArgumentParser.FutureArgumentParser<C, O1> flatMap(MappedArgumentParser.Mapper<C, O, O1> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return new MappedArgumentParserImpl(this.base, (ctx, orig) -> this.mapper.map(ctx, orig).thenCompose(mapped -> mapper.map(ctx, (ArgumentParseResult)mapped)));
    }

    public int hashCode() {
        return 31 + this.base.hashCode() + 7 * this.mapper.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MappedArgumentParserImpl)) {
            return false;
        }
        MappedArgumentParserImpl that = (MappedArgumentParserImpl)other;
        return this.base.equals(that.base) && this.mapper.equals(that.mapper);
    }

    public String toString() {
        return "MappedArgumentParserImpl{base=" + this.base + ',' + "mapper=" + this.mapper + '}';
    }
}

