/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.parser.WrappedBrigadierParser;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.sponge.NodeSource;
import org.empirewar.orbis.sponge.libs.cloud.sponge.SpongeCaptionKeys;
import org.empirewar.orbis.sponge.libs.cloud.sponge.SpongeCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionProvider;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class GameProfileParser<C>
implements ArgumentParser.FutureArgumentParser<C, GameProfile>,
NodeSource,
SuggestionProvider<C> {
    private final ArgumentParser<C, GameProfile> mappedParser = new WrappedBrigadierParser((ArgumentType<GameProfileArgument.Result>)GameProfileArgument.gameProfile()).flatMapSuccess((ctx, argumentResult) -> {
        Collection profiles;
        try {
            profiles = argumentResult.getNames((CommandSourceStack)ctx.get(SpongeCommandContextKeys.COMMAND_CAUSE));
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failureFuture(ex);
        }
        if (profiles.size() > 1) {
            return ArgumentParseResult.failureFuture(new TooManyGameProfilesSelectedException((CommandContext<?>)ctx));
        }
        SpongeGameProfile profile = SpongeGameProfile.of((com.mojang.authlib.GameProfile)((com.mojang.authlib.GameProfile)profiles.iterator().next()));
        return ArgumentParseResult.successFuture(profile);
    });

    public static <C> ParserDescriptor<C, GameProfile> gameProfileParser() {
        return ParserDescriptor.of(new GameProfileParser<C>(), GameProfile.class);
    }

    @Override
    public @NonNull CompletableFuture<ArgumentParseResult<@NonNull GameProfile>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        return this.mappedParser.parseFuture(commandContext, inputQueue);
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return this.mappedParser.suggestionProvider().suggestionsFuture(context, input);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.GAME_PROFILE.get(new RegistryHolder[]{registryHolder})).createNode();
    }

    private static final class TooManyGameProfilesSelectedException
    extends ParserException {
        private static final long serialVersionUID = -2931411139985042222L;

        TooManyGameProfilesSelectedException(@NonNull CommandContext<?> context) {
            super(GameProfileParser.class, context, SpongeCaptionKeys.ARGUMENT_PARSE_FAILURE_GAME_PROFILE_TOO_MANY_SELECTED, new CaptionVariable[0]);
        }
    }
}

