/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.parser.WrappedBrigadierParser;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.sponge.NodeSource;
import org.empirewar.orbis.sponge.libs.cloud.sponge.SpongeCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.sponge.data.MultiplePlayerSelector;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionProvider;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.registry.RegistryHolder;

public final class MultiplePlayerSelectorParser<C>
implements NodeSource,
ArgumentParser.FutureArgumentParser<C, MultiplePlayerSelector>,
SuggestionProvider<C> {
    private final ArgumentParser<C, EntitySelector> nativeParser = new WrappedBrigadierParser<C, EntitySelector>((ArgumentType<EntitySelector>)EntityArgument.players());

    public static <C> ParserDescriptor<C, MultiplePlayerSelector> multiplePlayerSelectorParser() {
        return ParserDescriptor.of(new MultiplePlayerSelectorParser<C>(), MultiplePlayerSelector.class);
    }

    @Override
    public @NonNull CompletableFuture<ArgumentParseResult<@NonNull MultiplePlayerSelector>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        CommandInput originalInput = inputQueue.copy();
        return this.nativeParser.parseFuture(commandContext, inputQueue).thenApply(result -> {
            List<ServerPlayer> players;
            if (result.failure().isPresent()) {
                return ArgumentParseResult.failure(result.failure().get());
            }
            String consumedInput = originalInput.difference(inputQueue);
            EntitySelector parsed = (EntitySelector)result.parsedValue().get();
            try {
                players = parsed.findPlayers(((CommandSourceStack)commandContext.get(SpongeCommandContextKeys.COMMAND_CAUSE)).withPermission(2)).stream().map(p -> (ServerPlayer)p).collect(Collectors.toList());
            }
            catch (CommandSyntaxException ex) {
                return ArgumentParseResult.failure(ex);
            }
            return ArgumentParseResult.success(new MultiplePlayerSelectorImpl((Selector)parsed, consumedInput, players));
        });
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return this.nativeParser.suggestionProvider().suggestionsFuture(context, input);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return ((CommandTreeNode.EntitySelection)((CommandTreeNodeType)CommandTreeNodeTypes.ENTITY.get(new RegistryHolder[]{registryHolder})).createNode()).playersOnly();
    }

    private static final class MultiplePlayerSelectorImpl
    implements MultiplePlayerSelector {
        private final Selector selector;
        private final String inputString;
        private final Collection<ServerPlayer> result;

        private MultiplePlayerSelectorImpl(Selector selector, String inputString, Collection<ServerPlayer> result) {
            this.selector = selector;
            this.inputString = inputString;
            this.result = result;
        }

        @Override
        public @NonNull Selector selector() {
            return this.selector;
        }

        @Override
        public @NonNull String inputString() {
            return this.inputString;
        }

        @Override
        public @NonNull Collection<ServerPlayer> get() {
            return this.result;
        }
    }
}

