/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge.parser;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.DimensionArgument;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.sponge.NodeSource;
import org.empirewar.orbis.sponge.libs.cloud.sponge.parser.ResourceKeyUtil;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.BlockingSuggestionProvider;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.world.server.ServerWorld;

public final class WorldParser<C>
implements ArgumentParser<C, ServerWorld>,
NodeSource,
BlockingSuggestionProvider.Strings<C> {
    private static final Supplier<DynamicCommandExceptionType> ERROR_INVALID_VALUE = Suppliers.memoize(() -> {
        try {
            Field errorInvalidValueField = Arrays.stream(DimensionArgument.class.getDeclaredFields()).filter(f -> f.getType().equals(DynamicCommandExceptionType.class)).findFirst().orElseThrow(IllegalStateException::new);
            errorInvalidValueField.setAccessible(true);
            return (DynamicCommandExceptionType)errorInvalidValueField.get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't access ERROR_INVALID_VALUE command exception type.", ex);
        }
    });

    public static <C> ParserDescriptor<C, ServerWorld> worldParser() {
        return ParserDescriptor.of(new WorldParser<C>(), ServerWorld.class);
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull ServerWorld> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        String input = inputQueue.readString();
        ResourceKey key = ResourceKeyUtil.resourceKey(input);
        if (key == null) {
            return ResourceKeyUtil.invalidResourceKey();
        }
        Optional entry = Sponge.server().worldManager().world(key);
        if (entry.isPresent()) {
            return ArgumentParseResult.success((ServerWorld)entry.get());
        }
        return ArgumentParseResult.failure(ERROR_INVALID_VALUE.get().create((Object)key));
    }

    public @NonNull List<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Sponge.server().worldManager().worlds().stream().flatMap((? super T world) -> {
            if (!input.isEmpty() && world.key().namespace().equals("minecraft")) {
                return Stream.of(world.key().value(), world.key().asString());
            }
            return Stream.of(world.key().asString());
        }).collect(Collectors.toList());
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.RESOURCE_LOCATION.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions();
    }
}

