/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.empirewar.orbis.sponge.libs.rtree.Splitter;
import org.empirewar.orbis.sponge.libs.rtree.geometry.HasGeometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.ListPair;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Rectangle;
import org.empirewar.orbis.sponge.libs.rtree.guava.Lists;
import org.empirewar.orbis.sponge.libs.rtree.guava.Preconditions;
import org.empirewar.orbis.sponge.libs.rtree.guava.annotations.VisibleForTesting;
import org.empirewar.orbis.sponge.libs.rtree.internal.Util;
import org.empirewar.orbis.sponge.libs.rtree.internal.util.Pair;

public final class SplitterQuadratic
implements Splitter {
    public static final SplitterQuadratic INSTANCE = new SplitterQuadratic();

    private SplitterQuadratic() {
    }

    @Override
    public <T extends HasGeometry> ListPair<T> split(List<T> items, int minSize) {
        Preconditions.checkArgument(items.size() >= 2);
        Pair<T> worstCombination = SplitterQuadratic.worstCombination(items);
        ArrayList<HasGeometry> group1 = Lists.newArrayList((HasGeometry)worstCombination.value1());
        ArrayList<HasGeometry> group2 = Lists.newArrayList((HasGeometry)worstCombination.value2());
        ArrayList<T> remaining = new ArrayList<T>(items);
        remaining.remove(worstCombination.value1());
        remaining.remove(worstCombination.value2());
        int minGroupSize = items.size() / 2;
        while (remaining.size() > 0) {
            this.assignRemaining(group1, group2, remaining, minGroupSize);
        }
        return new ListPair<HasGeometry>(group1, group2);
    }

    private <T extends HasGeometry> void assignRemaining(List<T> group1, List<T> group2, List<T> remaining, int minGroupSize) {
        boolean volume1LessThanVolume2;
        Rectangle mbr1 = Util.mbr(group1);
        Rectangle mbr2 = Util.mbr(group2);
        T item1 = SplitterQuadratic.getBestCandidateForGroup(remaining, group1, mbr1);
        T item2 = SplitterQuadratic.getBestCandidateForGroup(remaining, group2, mbr2);
        boolean bl = volume1LessThanVolume2 = item1.geometry().mbr().add(mbr1).volume() <= item2.geometry().mbr().add(mbr2).volume();
        if (volume1LessThanVolume2 && group2.size() + remaining.size() - 1 >= minGroupSize || !volume1LessThanVolume2 && group1.size() + remaining.size() == minGroupSize) {
            group1.add(item1);
            remaining.remove(item1);
        } else {
            group2.add(item2);
            remaining.remove(item2);
        }
    }

    @VisibleForTesting
    static <T extends HasGeometry> T getBestCandidateForGroup(List<T> list, List<T> group, Rectangle groupMbr) {
        Optional<Object> minEntry = Optional.empty();
        Optional<Object> minVolume = Optional.empty();
        for (HasGeometry entry : list) {
            double volume = groupMbr.add(entry.geometry().mbr()).volume();
            if (minVolume.isPresent() && !(volume < (Double)minVolume.get())) continue;
            minVolume = Optional.of(volume);
            minEntry = Optional.of(entry);
        }
        return (T)((HasGeometry)minEntry.get());
    }

    @VisibleForTesting
    static <T extends HasGeometry> Pair<T> worstCombination(List<T> items) {
        Optional<Object> e1 = Optional.empty();
        Optional<Object> e2 = Optional.empty();
        Optional<Object> maxVolume = Optional.empty();
        for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                HasGeometry entry1 = (HasGeometry)items.get(i);
                HasGeometry entry2 = (HasGeometry)items.get(j);
                double volume = entry1.geometry().mbr().add(entry2.geometry().mbr()).volume();
                if (maxVolume.isPresent() && !(volume > (Double)maxVolume.get())) continue;
                e1 = Optional.of(entry1);
                e2 = Optional.of(entry2);
                maxVolume = Optional.of(volume);
            }
        }
        if (e1.isPresent()) {
            return new Pair(e1.get(), e2.get());
        }
        return new Pair<T>(items.get(0), items.get(1));
    }
}

