/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.empirewar.orbis.sponge.libs.rtree.Splitter;
import org.empirewar.orbis.sponge.libs.rtree.geometry.HasGeometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.ListPair;
import org.empirewar.orbis.sponge.libs.rtree.guava.Preconditions;
import org.empirewar.orbis.sponge.libs.rtree.guava.annotations.VisibleForTesting;

public final class SplitterRStar
implements Splitter {
    public static final SplitterRStar INSTANCE = new SplitterRStar();
    private final Comparator<ListPair<?>> comparator = new Comparator<ListPair<?>>(){

        @Override
        public int compare(ListPair<?> p1, ListPair<?> p2) {
            int value = Double.compare(SplitterRStar.overlap(p1), SplitterRStar.overlap(p2));
            if (value == 0) {
                return Double.compare(p1.volumeSum(), p2.volumeSum());
            }
            return value;
        }
    };
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    private SplitterRStar() {
    }

    @Override
    public <T extends HasGeometry> ListPair<T> split(List<T> items, int minSize) {
        Preconditions.checkArgument(!items.isEmpty());
        List<ListPair<T>> pairs = null;
        double lowestMarginSum = Double.POSITIVE_INFINITY;
        ArrayList<T> list = null;
        for (int i = 0; i < ((HasGeometry)items.get(0)).geometry().dimensions(); ++i) {
            for (boolean isUpper : BOOLEANS) {
                if (list == null) {
                    list = new ArrayList<T>(items);
                }
                Collections.sort(list, SplitterRStar.comparator(i, isUpper));
                List<ListPair<T>> p = SplitterRStar.getPairs(minSize, list);
                double marginSum = SplitterRStar.marginValueSum(p);
                if (!(marginSum <= lowestMarginSum)) continue;
                lowestMarginSum = marginSum;
                pairs = p;
                list = null;
            }
        }
        return Collections.min(pairs, this.comparator);
    }

    private static Comparator<HasGeometry> comparator(int dimension, boolean upper) {
        if (upper) {
            return (a, b) -> Double.compare(a.geometry().mbr().max(dimension), b.geometry().mbr().max(dimension));
        }
        return (a, b) -> Double.compare(a.geometry().mbr().min(dimension), b.geometry().mbr().min(dimension));
    }

    private static <T extends HasGeometry> double marginValueSum(List<ListPair<T>> list) {
        double sum = 0.0;
        for (ListPair<T> p : list) {
            sum += p.marginSum();
        }
        return sum;
    }

    @VisibleForTesting
    static <T extends HasGeometry> List<ListPair<T>> getPairs(int minSize, List<T> list) {
        ArrayList<ListPair<T>> pairs = new ArrayList<ListPair<T>>(list.size() - 2 * minSize + 1);
        for (int i = minSize; i < list.size() - minSize + 1; ++i) {
            List<T> list1 = list.subList(0, i);
            List<T> list2 = list.subList(i, list.size());
            ListPair<T> pair = new ListPair<T>(list1, list2);
            pairs.add(pair);
        }
        return pairs;
    }

    private static double overlap(ListPair<? extends HasGeometry> pair) {
        return pair.group1().geometry().mbr().intersectionVolume(pair.group2().geometry().mbr());
    }
}

