/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree.geometry;

import org.empirewar.orbis.sponge.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.HasGeometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.internal.RectangleDouble;
import org.empirewar.orbis.sponge.libs.rtree.guava.Preconditions;

public interface Rectangle
extends Geometry,
HasGeometry {
    public double[] mins();

    public double[] maxes();

    public double volume();

    public double intersectionVolume(Rectangle var1);

    public double surfaceArea();

    public Rectangle add(Rectangle var1);

    public boolean contains(double ... var1);

    default public double min(int index) {
        return this.mins()[index];
    }

    default public double max(int index) {
        return this.maxes()[index];
    }

    public static Rectangle create(double[] mins, double[] maxes) {
        return RectangleDouble.create(mins, maxes);
    }

    public static Rectangle createOrdered(double[] x, double[] y) {
        Preconditions.checkArgument(x.length == y.length, "x and y must have same length");
        double[] mins = new double[x.length];
        double[] maxes = new double[y.length];
        for (int i = 0; i < x.length; ++i) {
            mins[i] = Math.min(x[i], y[i]);
            maxes[i] = Math.max(x[i], y[i]);
        }
        return Rectangle.create(mins, maxes);
    }

    public static Rectangle create(double ... values) {
        Preconditions.checkArgument(values.length >= 4 && values.length % 2 == 0, "must be at least 4 values passed and the number of values must be even");
        double[] x = new double[values.length / 2];
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = values[i];
            y[i] = values[i + x.length];
        }
        return Rectangle.create(x, y);
    }
}

