/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree.internal;

import java.util.Comparator;
import java.util.List;
import org.empirewar.orbis.sponge.libs.rtree.Entry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.HasGeometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Rectangle;

public final class Comparators {
    private Comparators() {
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> overlapVolumeThenVolumeIncreaseThenVolumeComparator(final Rectangle r, final List<T> list) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                int value = Double.compare(Comparators.overlapVolume(r, list, g1), Comparators.overlapVolume(r, list, g2));
                if (value == 0 && (value = Double.compare(Comparators.volumeIncrease(r, g1), Comparators.volumeIncrease(r, g2))) == 0) {
                    value = Double.compare(Comparators.volume(r, g1), Comparators.volume(r, g2));
                }
                return value;
            }
        };
    }

    private static double volume(Rectangle r, HasGeometry g1) {
        return g1.geometry().mbr().add(r).volume();
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> volumeIncreaseThenVolumeComparator(final Rectangle r) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                int value = Double.compare(Comparators.volumeIncrease(r, g1), Comparators.volumeIncrease(r, g2));
                if (value == 0) {
                    value = Double.compare(Comparators.volume(r, g1), Comparators.volume(r, g2));
                }
                return value;
            }
        };
    }

    private static float overlapVolume(Rectangle r, List<? extends HasGeometry> list, HasGeometry g2) {
        Rectangle gPlusR = g2.geometry().mbr().add(r);
        float m4 = 0.0f;
        for (HasGeometry hasGeometry : list) {
            if (hasGeometry == g2) continue;
            m4 = (float)((double)m4 + gPlusR.intersectionVolume(hasGeometry.geometry().mbr()));
        }
        return m4;
    }

    private static double volumeIncrease(Rectangle r, HasGeometry g2) {
        Rectangle gPlusR = g2.geometry().mbr().add(r);
        return gPlusR.volume() - g2.geometry().mbr().volume();
    }

    public static <T, S extends Geometry> Comparator<Entry<T, S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<T, S>>(){

            @Override
            public int compare(Entry<T, S> e1, Entry<T, S> e2) {
                return Double.compare(e1.geometry().distance(r), e2.geometry().distance(r));
            }
        };
    }
}

