/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.empirewar.orbis.sponge.libs.rtree.Context;
import org.empirewar.orbis.sponge.libs.rtree.Factory;
import org.empirewar.orbis.sponge.libs.rtree.Node;
import org.empirewar.orbis.sponge.libs.rtree.RTree;
import org.empirewar.orbis.sponge.libs.rtree.Selector;
import org.empirewar.orbis.sponge.libs.rtree.SelectorMinimalVolumeIncrease;
import org.empirewar.orbis.sponge.libs.rtree.SelectorRStar;
import org.empirewar.orbis.sponge.libs.rtree.Splitter;
import org.empirewar.orbis.sponge.libs.rtree.SplitterQuadratic;
import org.empirewar.orbis.sponge.libs.rtree.SplitterRStar;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.sponge.libs.rtree.internal.Serializer;

public class SerializerKryo<T, S extends Geometry>
implements Serializer<T, S> {
    private static final int VERSION = 1;

    @Override
    public void write(RTree<T, S> tree, OutputStream out) throws IOException {
        Kryo k = SerializerKryo.createKryo();
        k.writeObject(new Output(out), tree);
    }

    @Override
    public RTree<T, S> read(InputStream in) {
        Kryo k = SerializerKryo.createKryo();
        return (RTree)k.readObject(new Input(in), RTree.class);
    }

    private static Kryo createKryo() {
        Kryo k = new Kryo();
        k.register(RTree.class, (com.esotericsoftware.kryo.Serializer)new com.esotericsoftware.kryo.Serializer<RTree<Object, Geometry>>(){

            public RTree<Object, Geometry> read(Kryo k, Input input, Class<? extends RTree<Object, Geometry>> cls) {
                short version = input.readShort();
                short dimensions = input.readShort();
                short minChildren = input.readShort();
                short maxChildren = input.readShort();
                Splitter splitter = input.readShort() == 0 ? SplitterQuadratic.INSTANCE : SplitterRStar.INSTANCE;
                Selector selector = input.readShort() == 0 ? SelectorRStar.INSTANCE : SelectorMinimalVolumeIncrease.INSTANCE;
                boolean rootNodeIsPresent = input.readBoolean();
                if (rootNodeIsPresent) {
                    Node node = (Node)k.readObject(input, Node.class);
                    return new RTree<Object, Geometry>(Optional.of(node), 0, new Context(dimensions, minChildren, maxChildren, selector, splitter, Factory.defaultFactory()));
                }
                return new RTree<Object, Geometry>(Optional.empty(), 0, new Context(dimensions, minChildren, maxChildren, selector, splitter, Factory.defaultFactory()));
            }

            public void write(Kryo k, Output output, RTree<Object, Geometry> tree) {
                output.writeShort(1);
                output.writeShort(tree.dimensions());
                output.writeShort(tree.context().minChildren());
                output.writeShort(tree.context().maxChildren());
                short splitter = (short)(!(tree.context().splitter() instanceof SplitterQuadratic) ? 1 : 0);
                short selector = (short)(tree.context().selector() instanceof SelectorRStar ? 1 : 0);
                output.writeShort((int)splitter);
                output.writeShort((int)selector);
                output.writeBoolean(tree.root().isPresent());
                if (tree.root().isPresent()) {
                    k.writeObject(output, tree.root().get());
                }
            }
        });
        return k;
    }
}

