/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.listener;

import net.kyori.adventure.key.Key;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;

public class DamageEntityListener {
    private final Orbis orbis;

    public DamageEntityListener(Orbis orbis) {
        this.orbis = orbis;
    }

    @Listener(order=Order.EARLY)
    public void onDamage(DamageEntityEvent event) {
        Entity attacked = event.entity();
        if (!(attacked instanceof ServerPlayer)) {
            return;
        }
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)((ServerWorld)attacked.serverLocation().world()).key());
        RegionQuery.FilterableRegionResult<RegionQuery.Position> query = world.query(RegionQuery.Position.builder().position(attacked.position().x(), attacked.position().y(), attacked.position().z()));
        if (query.query(RegionQuery.Flag.builder(DefaultFlags.INVULNERABILITY)).result().orElse(false).booleanValue()) {
            event.setCancelled(true);
        }
    }
}

