/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.listener;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.world.RegionisedWorld;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.entity.hanging.Painting;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.vehicle.Vehicle;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;

public final class InteractEntityListener {
    private final Orbis orbis;

    public InteractEntityListener(Orbis orbis) {
        this.orbis = orbis;
    }

    @Listener(order=Order.EARLY)
    public void onAttackDirect(InteractEntityEvent.Primary event) {
        List damageable;
        RegionQuery.Flag.Builder<Object> flagQueryBuilder;
        RegistryRegionFlag<Boolean> flag;
        Entity attacked = event.entity();
        ServerPlayer player = event.cause().first(ServerPlayer.class).orElse(null);
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)((ServerWorld)attacked.serverLocation().world()).key());
        RegionQuery.FilterableRegionResult<RegionQuery.Position> positionQuery = world.query(RegionQuery.Position.at(attacked.position().x(), attacked.position().y(), attacked.position().z()));
        Entity entity = attacked;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Vehicle.class, Painting.class, ItemFrame.class}, (Object)entity2, n)) {
            case 0: {
                Vehicle ignored = (Vehicle)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_VEHICLE;
                break;
            }
            case 1: {
                Painting ignored = (Painting)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_PAINTING;
                break;
            }
            case 2: {
                ItemFrame ignored = (ItemFrame)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_ITEM_FRAME;
                break;
            }
            default: {
                RegistryRegionFlag<Boolean> registryRegionFlag = flag = null;
            }
        }
        if (flag != null) {
            flagQueryBuilder = RegionQuery.Flag.builder(flag);
            if (player != null) {
                flagQueryBuilder.player(player.uniqueId());
            }
            if (!positionQuery.query(flagQueryBuilder).result().orElse(true).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (!(attacked instanceof Living)) {
            return;
        }
        if (attacked instanceof ServerPlayer) {
            if (this.orbis.config().node(new Object[]{"cancel-pvp-hit-sounds"}).getBoolean(true) && this.shouldPreventEntityAction(attacked, (Entity)player, DefaultFlags.CAN_PVP)) {
                event.setCancelled(true);
            }
            return;
        }
        flagQueryBuilder = RegionQuery.Flag.builder(DefaultFlags.DAMAGEABLE_ENTITIES);
        if (player != null) {
            flagQueryBuilder.player(player.uniqueId());
        }
        if ((damageable = (List)positionQuery.query(flagQueryBuilder).result().orElse(null)) == null) {
            return;
        }
        if (!damageable.contains(attacked.type().key(RegistryTypes.ENTITY_TYPE))) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onAttack(AttackEntityEvent.Post event, @First ServerPlayer attacker) {
        if (this.orbis.config().node(new Object[]{"cancel-pvp-hit-sounds"}).getBoolean(true)) {
            return;
        }
        Entity attacked = event.entity();
        if (this.shouldPreventEntityAction(attacked, (Entity)attacker, DefaultFlags.CAN_PVP)) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onFallDamage(DamageEntityEvent event) {
        Entity entity = event.entity();
        Object object = event.source();
        if (object instanceof DamageSource) {
            DamageSource damageSource = (DamageSource)object;
            DamageType type = damageSource.type();
            if (type != DamageTypes.FALL.get()) {
                return;
            }
            if (this.shouldPreventEntityAction(entity, DefaultFlags.FALL_DAMAGE)) {
                event.setCancelled(true);
            }
        }
    }

    @Listener(order=Order.EARLY)
    public void onMobDirectDamage(DamageEntityEvent event, @First Living damager) {
        Entity entity = event.entity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (!(damager instanceof ServerPlayer) && this.shouldPreventEntityAction(entity, DefaultFlags.CAN_TAKE_MOB_DAMAGE_SOURCES)) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onDrop(ChangeInventoryEvent.Drop event, @First ServerPlayer player) {
        if (this.shouldPreventEntityAction((Entity)player, DefaultFlags.CAN_DROP_ITEM)) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onPickup(ChangeInventoryEvent.Pickup event, @Root ServerPlayer player) {
        if (this.shouldPreventEntityAction((Entity)player, DefaultFlags.CAN_PICKUP_ITEM)) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onRotate(InteractEntityEvent.Secondary event) {
        boolean rotate;
        Entity entity = event.entity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        boolean bl = rotate = !((ItemStackSnapshot)itemFrame.item().get()).isEmpty();
        if (rotate) {
            if (this.shouldPreventEntityAction((Entity)itemFrame, DefaultFlags.ITEM_FRAME_ROTATE)) {
                event.setCancelled(true);
            }
        } else if (this.shouldPreventEntityAction((Entity)itemFrame, DefaultFlags.ITEM_FRAME_ITEM_PLACE)) {
            event.setCancelled(true);
        }
    }

    private boolean shouldPreventEntityAction(Entity entity, RegistryRegionFlag<Boolean> flag) {
        return this.shouldPreventEntityAction(entity, entity, flag);
    }

    private boolean shouldPreventEntityAction(Entity entity, @Nullable Entity player, RegistryRegionFlag<Boolean> flag) {
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)((ServerWorld)entity.serverLocation().world()).key());
        if (world == null) {
            return false;
        }
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.uniqueId());
        }
        Vector3d location = entity.position();
        return world.query(RegionQuery.Position.builder().position(location.x(), location.y(), location.z())).query(builder).result().orElse(true) == false;
    }
}

