/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.listener;

import java.util.Set;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.sponge.api.RegionEnterEvent;
import org.empirewar.orbis.sponge.api.RegionLeaveEvent;
import org.empirewar.orbis.world.RegionisedWorld;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.plugin.PluginContainer;

public final class MovementListener {
    private final Orbis orbis;

    public MovementListener(Orbis orbis) {
        this.orbis = orbis;
    }

    @Listener
    public void onMove(MoveEntityEvent event) {
        Entity entity = event.entity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Vector3d to = event.destinationPosition();
        Vector3d from = event.originalPosition();
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)player.world().key());
        if (event.context().get(EventContextKeys.MOVEMENT_TYPE).orElse(null) == MovementTypes.ENTITY_TELEPORT.get()) {
            boolean canMove = world.query(RegionQuery.Position.builder().position(to.x(), to.y(), to.z())).query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.uniqueId())).result().orElse(true);
            if (!canMove) {
                event.setCancelled(true);
            }
            return;
        }
        RegionQuery.FilterableRegionResult<RegionQuery.Position> toQuery = world.query(RegionQuery.Position.builder().position(to.x(), to.y(), to.z()));
        boolean canMove = toQuery.query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.uniqueId())).result().orElse(true);
        if (!canMove) {
            event.setCancelled(true);
            return;
        }
        RegionQuery.FilterableRegionResult<RegionQuery.Position> fromQuery = world.query(RegionQuery.Position.builder().position(from.x(), from.y(), from.z()));
        Set toRegions = (Set)toQuery.result();
        Set fromRegions = (Set)fromQuery.result();
        for (Region possiblyEntered : toRegions) {
            if (fromRegions.contains(possiblyEntered)) continue;
            Sponge.eventManager().post((Event)new RegionEnterEvent(player, ServerLocation.of((ServerWorld)player.world(), (Vector3d)to), world, possiblyEntered, event.cause()));
        }
        for (Region possiblyLeft : fromRegions) {
            if (toRegions.contains(possiblyLeft)) continue;
            Sponge.eventManager().post((Event)new RegionLeaveEvent(player, ServerLocation.of((ServerWorld)player.world(), (Vector3d)to), world, possiblyLeft, event.cause()));
        }
    }

    @Listener
    public void onFoodLevelChange(ChangeDataHolderEvent.ValueChange event) {
        DataHolder.Mutable mutable = event.targetHolder();
        if (!(mutable instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer entity = (ServerPlayer)mutable;
        if (event.endResult().successfulData().stream().noneMatch(immutable -> immutable.key() == Keys.FOOD_LEVEL)) {
            return;
        }
        if (event.cause().containsType(PluginContainer.class)) {
            return;
        }
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)entity.world().key());
        boolean drain = world.query(RegionQuery.Position.builder().position(entity.position().x(), entity.position().y(), entity.position().z())).query(RegionQuery.Flag.builder(DefaultFlags.DRAIN_HUNGER).player(entity.uniqueId())).result().orElse(true);
        if (drain) {
            return;
        }
        event.setCancelled(true);
    }
}

