/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.selection;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.sponge.key.SpongeDataKeys;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;
import org.joml.Vector3ic;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SelectionListener {
    private final Orbis api;

    public SelectionListener(Orbis api) {
        this.api = api;
    }

    @Listener
    public void onRightClick(InteractItemEvent.Secondary.Pre event, @Root ServerPlayer player) {
        if (!player.hasPermission("orbis.manage")) {
            return;
        }
        ItemStackSnapshot item = event.context().get(EventContextKeys.USED_ITEM).orElse(ItemStackSnapshot.empty());
        if (item.isEmpty() || !((Boolean)item.getOrElse(SpongeDataKeys.IS_WAND, (Object)false)).booleanValue()) {
            return;
        }
        Selection selection = this.api.selectionManager().get(player.uniqueId()).orElse(null);
        if (selection == null) {
            player.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_NOT_ACTIVE));
            return;
        }
        Vector3ic last = selection.getPoints().stream().reduce((first, second) -> second).orElse(null);
        if (last == null) {
            return;
        }
        selection.removePoint(last);
        player.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_REMOVED));
    }

    @Listener
    public void onLeftClick(InteractBlockEvent.Primary.Start event, @Root ServerPlayer player) {
        org.joml.Vector3i point;
        if (!player.hasPermission("orbis.manage")) {
            return;
        }
        ItemStackSnapshot item = event.context().get(EventContextKeys.USED_ITEM).orElse(ItemStackSnapshot.empty());
        if (item.isEmpty() || !((Boolean)item.getOrElse(SpongeDataKeys.IS_WAND, (Object)false)).booleanValue()) {
            return;
        }
        Selection selection = this.api.selectionManager().get(player.uniqueId()).orElseGet(() -> {
            Selection newSelection = new Selection(AreaType.CUBOID);
            this.api.selectionManager().add(player.uniqueId(), newSelection);
            player.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Started a new cuboid selection.", (TextColor)OrbisText.EREBOR_GREEN)));
            return newSelection;
        });
        BlockSnapshot block = event.block();
        if (block == null || block.state().type().isAnyOf(new BlockType[]{(BlockType)BlockTypes.AIR.get(), (BlockType)BlockTypes.CAVE_AIR.get(), (BlockType)BlockTypes.VOID_AIR.get()})) {
            Vector3i blockPos = player.blockPosition();
            point = new org.joml.Vector3i(blockPos.x(), blockPos.y(), blockPos.z());
        } else {
            Vector3i blockPos = block.position();
            point = new org.joml.Vector3i(blockPos.x(), blockPos.y(), blockPos.z());
        }
        selection.addPoint((Vector3ic)point);
        player.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_ADDED.arguments(new ComponentLike[]{Component.text((int)point.x), Component.text((int)point.y), Component.text((int)point.z)})).hoverEvent((HoverEventSource)HoverEvent.showText((Component)OrbisTranslations.GENERIC_CLICK_TO_TELEPORT)).clickEvent(ClickEvent.callback(audience -> player.setPosition(new Vector3d((float)point.x, (float)point.y, (float)point.z)), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(3L)).build()))));
        event.setCancelled(true);
    }
}

