/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.task;

import java.util.UUID;
import java.util.function.Supplier;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.task.RegionVisualiserTaskBase;
import org.joml.Vector3dc;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;

public class SpongeRegionVisualiserTask
extends RegionVisualiserTaskBase
implements Runnable {
    public SpongeRegionVisualiserTask(OrbisPlatform platform) {
        super(platform);
    }

    @Override
    protected Vector3dc getPlayerPosition(UUID uuid) {
        ServerPlayer player = (ServerPlayer)Sponge.server().player(uuid).orElseThrow();
        Vector3d loc = player.position();
        return new org.joml.Vector3d(loc.x(), loc.y(), loc.z());
    }

    @Override
    protected void showGreenParticle(UUID uuid, Vector3dc point) {
        ServerPlayer player = (ServerPlayer)Sponge.server().player(uuid).orElseThrow();
        ServerWorld world = player.world();
        world.spawnParticles(ParticleEffect.builder().type((ParticleType)ParticleTypes.HAPPY_VILLAGER.get()).build(), new Vector3d(point.x(), point.y(), point.z()));
    }

    @Override
    protected void showOrangeParticle(UUID uuid, Vector3dc point) {
        ServerPlayer player = (ServerPlayer)Sponge.server().player(uuid).orElseThrow();
        ServerWorld world = player.world();
        world.spawnParticles(ParticleEffect.builder().type((ParticleType)ParticleTypes.DUST.get()).option((Supplier)ParticleOptions.COLOR, (Object)Color.ofRgb((int)255, (int)165, (int)0)).option((Supplier)ParticleOptions.SCALE, (Object)2.0).build(), new Vector3d(point.x(), point.y(), point.z()));
    }
}

