/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.modded.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CoralBlock;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.modded.util.FlagActions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CoralBlock.class})
public abstract class CoralBlockMixin {
    @Inject(method={"scanForWater(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onScanForWater(BlockGetter blockGetter, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (!(blockGetter instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)blockGetter;
        if (FlagActions.shouldPreventBlockAction((Level)level, blockPos, null, DefaultFlags.CORAL_DECAY)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }
}

