/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.modded.command.ModdedCommands;
import org.empirewar.orbis.neoforge.listener.BlockActionListener;
import org.empirewar.orbis.neoforge.listener.ConnectionListener;
import org.empirewar.orbis.neoforge.listener.InteractEntityListener;
import org.empirewar.orbis.neoforge.listener.MovementListener;
import org.empirewar.orbis.neoforge.listener.RegionMessagesListener;
import org.empirewar.orbis.neoforge.selection.SelectionListener;
import org.empirewar.orbis.neoforge.session.NeoForgeConsoleSession;
import org.empirewar.orbis.neoforge.session.NeoForgePlayerSession;
import org.empirewar.orbis.selection.Selection;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.neoforge.NeoForgeServerCommandManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="orbis")
public class OrbisNeoForge
extends OrbisPlatform {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"orbis");
    private volatile MinecraftServerAudiences adventure;
    private volatile MinecraftServer server;
    private ItemStack wandItem;
    private final Path dataFolder = Path.of("config", "orbis");
    public static final PermissionNode<Boolean> ORBIS_MANAGE = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"orbis", (String)"orbis.manage"), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]);

    public OrbisNeoForge() {
        this.load();
        new ModdedCommands<NeoForgeServerCommandManager>(new NeoForgeServerCommandManager(ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(sender -> {
            ServerPlayer patt0$temp = sender.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = patt0$temp;
                return new NeoForgePlayerSession(player, (CommandSourceStack)sender);
            }
            return new NeoForgeConsoleSession((CommandSourceStack)sender);
        }, session -> {
            if (session instanceof NeoForgePlayerSession) {
                NeoForgePlayerSession playerSession = (NeoForgePlayerSession)session;
                return playerSession.getCause();
            }
            return ((NeoForgeConsoleSession)session).cause();
        })));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public MinecraftServerAudiences adventure() {
        MinecraftServerAudiences ret = this.adventure;
        if (ret == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ret;
    }

    public ItemStack getWandItem() {
        return this.wandItem.copy();
    }

    public MinecraftServer server() {
        return this.server;
    }

    @SubscribeEvent
    public void onPermissionNodesRegister(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{ORBIS_MANAGE});
    }

    @SubscribeEvent
    public void onServerStarting(ServerAboutToStartEvent event) {
        this.adventure = MinecraftServerAudiences.of((MinecraftServer)event.getServer());
        this.server = event.getServer();
        this.registerListeners();
        try {
            this.loadRegions();
        }
        catch (IOException e) {
            this.logger().error("Error loading regions", (Throwable)e);
        }
        this.wandItem = new ItemStack((ItemLike)Items.BLAZE_ROD);
        this.wandItem.set(DataComponents.ITEM_NAME, (Object)this.adventure.asNative(Selection.WAND_NAME));
        this.wandItem.set(DataComponents.LORE, (Object)new ItemLore(Selection.WAND_LORE.stream().map(arg_0 -> ((MinecraftServerAudiences)this.adventure).asNative(arg_0)).toList()));
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)this.wandItem, compoundTag -> {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("orbis_is_wand", true);
            compoundTag.merge(tag);
        });
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        try {
            this.saveRegions();
        }
        catch (IOException e) {
            this.logger().error("Error saving regions", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        this.adventure = null;
        this.server = null;
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.loadWorld(((Keyed)serverLevel.dimension()).key(), UUID.randomUUID());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.saveWorld(((Keyed)serverLevel.dimension()).key(), UUID.randomUUID());
        }
    }

    private void registerListeners() {
        new SelectionListener(this);
        new ConnectionListener(this);
        new InteractEntityListener(this);
        new BlockActionListener(this);
        new MovementListener(this);
        new RegionMessagesListener(this);
    }

    @Override
    public Key getPlayerWorld(UUID player) {
        return ((Keyed)this.server.getPlayerList().getPlayer(player).level().dimension()).key();
    }

    @Override
    public boolean hasPermission(UUID player, String permission) {
        ServerPlayer vanilla = this.server.getPlayerList().getPlayer(player);
        if (vanilla == null) {
            return false;
        }
        return vanilla.hasPermissions(3);
    }

    @Override
    public Path dataFolder() {
        return this.dataFolder;
    }

    @Override
    protected InputStream getResourceAsStream(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }
}

