/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.command;

import io.leangen.geantyref.TypeToken;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.empirewar.orbis.command.CommonCommands;
import org.empirewar.orbis.command.parser.FlagValueParser;
import org.empirewar.orbis.command.parser.RegionFlagParser;
import org.empirewar.orbis.command.parser.RegionisedWorldParser;
import org.empirewar.orbis.command.parser.registry.RegistryValueParser;
import org.empirewar.orbis.migrations.rpgregions.RPGRegionsMigrator;
import org.empirewar.orbis.migrations.worldguard.WorldGuardMigrator;
import org.empirewar.orbis.paper.libs.cloud.CommandManager;
import org.empirewar.orbis.paper.libs.cloud.brigadier.BrigadierManagerHolder;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitCommandManager;
import org.empirewar.orbis.paper.libs.cloud.bukkit.CloudBukkitCapabilities;
import org.empirewar.orbis.paper.libs.cloud.bukkit.PluginHolder;
import org.empirewar.orbis.paper.libs.cloud.bukkit.internal.BukkitBrigadierMapper;
import org.empirewar.orbis.paper.libs.cloud.paper.LegacyPaperCommandManager;
import org.empirewar.orbis.paper.libs.cloud.paper.PaperCommandManager;
import org.empirewar.orbis.player.OrbisSession;

public class BukkitCommands<M extends CommandManager<OrbisSession> & PluginHolder> {
    private final M manager;

    public BukkitCommands(M manager) {
        this.manager = manager;
        if (((CommandManager)manager).hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            if (manager instanceof BukkitCommandManager) {
                BukkitCommandManager bukkit = (BukkitCommandManager)manager;
                bukkit.registerBrigadier();
            }
        } else if (((CommandManager)manager).hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION) && manager instanceof LegacyPaperCommandManager) {
            LegacyPaperCommandManager legacy = (LegacyPaperCommandManager)manager;
            legacy.registerAsynchronousCompletions();
        }
        this.mapDumbBrigadierStuff();
        this.registerCommands();
    }

    private void registerCommands() {
        new CommonCommands((CommandManager<OrbisSession>)this.manager);
        ((CommandManager)this.manager).command(this.manager.commandBuilder("orbis", new String[0]).permission("orbis.manage").literal("migrate", new String[0]).literal("worldguard", new String[0]).handler(context -> {
            OrbisSession sender = (OrbisSession)context.sender();
            Plugin worldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard");
            if (worldGuard == null || !worldGuard.isEnabled()) {
                sender.sendMessage((Component)Component.text((String)"WorldGuard is not installed. WorldGuard must be installed for migration to work.", (TextColor)NamedTextColor.RED));
                return;
            }
            new WorldGuardMigrator((Audience)sender);
        }));
        ((CommandManager)this.manager).command(this.manager.commandBuilder("orbis", new String[0]).permission("orbis.manage").literal("migrate", new String[0]).literal("rpgregions", new String[0]).handler(context -> {
            OrbisSession sender = (OrbisSession)context.sender();
            Plugin rpgregions = Bukkit.getPluginManager().getPlugin("RPGRegions");
            if (rpgregions == null || !rpgregions.isEnabled()) {
                sender.sendMessage((Component)Component.text((String)"RPGRegions is not installed. RPGRegions must be installed for migration to work.", (TextColor)NamedTextColor.RED));
                return;
            }
            new RPGRegionsMigrator((Audience)sender);
        }));
    }

    private void mapDumbBrigadierStuff() {
        if (!((BrigadierManagerHolder)this.manager).hasBrigadierManager()) {
            return;
        }
        Logger logger = this.manager instanceof PaperCommandManager ? Logger.getLogger("Orbis") : ((PluginHolder)this.manager).owningPlugin().getLogger();
        BukkitBrigadierMapper brigadierMapper = new BukkitBrigadierMapper(logger, ((BrigadierManagerHolder)this.manager).brigadierManager());
        brigadierMapper.mapSimpleNMS(new TypeToken<RegionFlagParser<OrbisSession>>(this){}, "resource_location", true);
        brigadierMapper.mapSimpleNMS(new TypeToken<RegionisedWorldParser<OrbisSession>>(this){}, "resource_location", true);
        brigadierMapper.mapSimpleNMS(new TypeToken<FlagValueParser<OrbisSession>>(this){}, "message", true);
        brigadierMapper.mapSimpleNMS(new TypeToken<RegistryValueParser<OrbisSession, ?, ?>>(this){}, "resource_location", true);
    }
}

