/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.listener;

import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record EntityDamageListener(OrbisBukkitPlatform<?> orbis) implements Listener
{
    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)player.getWorld()));
        Location location = player.getLocation();
        Vector3d pos = new Vector3d(location.getX(), location.getY(), location.getZ());
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(DefaultFlags.INVULNERABILITY);
        builder.player(player.getUniqueId());
        boolean canAct = world.query(RegionQuery.Position.builder().position((Vector3dc)pos)).query(builder).result().orElse(false);
        if (!canAct) {
            event.setCancelled(true);
        }
    }
}

