/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.listener;

import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.paper.api.event.RegionEnterEvent;
import org.empirewar.orbis.paper.api.event.RegionLeaveEvent;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.world.RegionisedWorld;

public record MovementListener(OrbisBukkitPlatform<?> orbis) implements Listener
{
    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Location to = event.getTo();
        Location from = event.getFrom();
        if (to == null || to.distanceSquared(from) == 0.0) {
            return;
        }
        Player player = event.getPlayer();
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)to.getWorld()));
        RegionQuery.FilterableRegionResult<RegionQuery.Position> toQuery = world.query(RegionQuery.Position.builder().position(to.getX(), to.getY(), to.getZ()));
        boolean canMove = toQuery.query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.getUniqueId())).result().orElse(true);
        if (!canMove) {
            event.setTo(new Location(from.getWorld(), from.getX(), from.getY(), from.getZ(), to.getYaw(), to.getPitch()));
            return;
        }
        RegionQuery.FilterableRegionResult<RegionQuery.Position> fromQuery = world.query(RegionQuery.Position.builder().position(from.getX(), from.getY(), from.getZ()));
        Set toRegions = (Set)toQuery.result();
        Set fromRegions = (Set)fromQuery.result();
        for (Region possiblyEntered : toRegions) {
            if (fromRegions.contains(possiblyEntered)) continue;
            Bukkit.getPluginManager().callEvent((Event)new RegionEnterEvent(player, to, world, possiblyEntered));
        }
        for (Region possiblyLeft : fromRegions) {
            if (toRegions.contains(possiblyLeft)) continue;
            Bukkit.getPluginManager().callEvent((Event)new RegionLeaveEvent(player, to, world, possiblyLeft));
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Location to = event.getTo();
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)to.getWorld()));
        boolean canMove = world.query(RegionQuery.Position.builder().position(to.getX(), to.getY(), to.getZ())).query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.getUniqueId())).result().orElse(true);
        if (!canMove) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        HumanEntity entity = event.getEntity();
        Location location = entity.getLocation();
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)entity.getWorld()));
        boolean drain = world.query(RegionQuery.Position.builder().position(location.getX(), location.getY(), location.getZ())).query(RegionQuery.Flag.builder(DefaultFlags.DRAIN_HUNGER).player(entity.getUniqueId())).result().orElse(true);
        if (drain) {
            return;
        }
        event.setCancelled(true);
    }
}

