/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.area.PolyhedralArea;
import org.empirewar.orbis.area.SphericalArea;
import org.empirewar.orbis.exception.IncompleteAreaException;
import org.empirewar.orbis.flag.GroupedMutableRegionFlag;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.flag.value.FlagValue;
import org.empirewar.orbis.member.FlagMemberGroup;
import org.empirewar.orbis.member.Member;
import org.empirewar.orbis.member.PermissionMember;
import org.empirewar.orbis.member.PlayerMember;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.paper.libs.cloud.annotation.specifier.Greedy;
import org.empirewar.orbis.paper.libs.cloud.annotations.Argument;
import org.empirewar.orbis.paper.libs.cloud.annotations.Command;
import org.empirewar.orbis.paper.libs.cloud.annotations.CommandDescription;
import org.empirewar.orbis.paper.libs.cloud.annotations.Flag;
import org.empirewar.orbis.paper.libs.cloud.annotations.Permission;
import org.empirewar.orbis.paper.libs.cloud.annotations.suggestion.Suggestions;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.context.CommandInput;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.empirewar.orbis.paper.libs.cloud.processors.confirmation.annotation.Confirmation;
import org.empirewar.orbis.paper.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.player.OrbisSession;
import org.empirewar.orbis.player.PlayerOrbisSession;
import org.empirewar.orbis.region.GlobalRegion;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;
import org.empirewar.orbis.world.RegionisedWorld;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@Permission(value={"orbis.manage"})
public final class RegionCommand {
    @Command(value="region|rg create|define <name> [area_type]")
    public void onCreate(OrbisSession session, @Flag(value="global") boolean global, @Flag(value="ignore-selection") boolean ignoreSelection, @Argument(value="name") String regionName, @Argument(value="area_type") @Nullable AreaType<?> areaType) {
        Area area;
        Orbis orbis = OrbisAPI.get();
        if (OrbisRegistries.REGIONS.get(regionName).isPresent()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_ALREADY_EXISTS.arguments(new ComponentLike[]{Component.text((String)regionName)})));
            return;
        }
        if (ignoreSelection) {
            areaType = null;
        }
        if (global) {
            area = null;
        } else if (ignoreSelection) {
            area = new CuboidArea();
        } else if (session instanceof PlayerOrbisSession) {
            AreaType<?> defaultedType;
            PlayerOrbisSession player = (PlayerOrbisSession)session;
            Selection selection = orbis.selectionManager().get(player.getUuid()).orElse(null);
            if (selection == null) {
                session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SELECTION_REQUIRED));
                return;
            }
            AreaType<?> areaType2 = defaultedType = areaType == null ? selection.getSelectionType() : areaType;
            if (selection.getSelectionType() != defaultedType) {
                session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SELECTION_TYPE_MISMATCH.arguments(new ComponentLike[]{Component.text((String)((Key)OrbisRegistries.AREA_TYPE.getKey(defaultedType).orElseThrow()).asString()), Component.text((String)((Key)OrbisRegistries.AREA_TYPE.getKey(selection.getSelectionType()).orElseThrow()).asString())})));
                return;
            }
            try {
                area = selection.build();
            }
            catch (IncompleteAreaException e) {
                session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_INCOMPLETE_SELECTION.arguments(new ComponentLike[]{Component.text((String)e.getMessage())})));
                return;
            }
            selection.getPoints().forEach(area::addPoint);
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_USED_SELECTION_NOTE));
        } else {
            area = areaType == null || areaType == AreaType.CUBOID ? new CuboidArea() : (areaType == AreaType.POLYGON ? new PolygonArea() : (areaType == AreaType.POLYHEDRAL ? new PolyhedralArea() : (areaType == AreaType.SPHERE ? new SphericalArea() : new CuboidArea())));
        }
        Region region = global ? new GlobalRegion(regionName) : new Region(regionName, area);
        OrbisRegistries.REGIONS.register(regionName, region);
        if (session instanceof PlayerOrbisSession) {
            PlayerOrbisSession player = (PlayerOrbisSession)session;
            if (!region.isGlobal()) {
                orbis.getRegionisedWorld(orbis.getPlayerWorld(player.getUuid())).add(region);
            }
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_CREATED.arguments(new ComponentLike[]{Component.text((String)regionName), Component.text((String)(global ? "global " : ""))})));
    }

    @Command(value="region|rg area set <region>")
    @CommandDescription(value="Set the area a region spans.")
    public void onSetArea(PlayerOrbisSession session, @Argument(value="region") Region region) {
        if (region.isGlobal()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_GLOBAL_AREA_NOT_SUPPORTED));
            return;
        }
        Selection selection = OrbisAPI.get().selectionManager().get(session.getUuid()).orElse(null);
        if (selection == null) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_NO_ACTIVE_SELECTION));
            return;
        }
        if (selection.getSelectionType() != region.area().getType()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SET_AREA_TYPE_MISMATCH.arguments(new ComponentLike[]{Component.text((String)region.area().getType().toString()), Component.text((String)selection.getSelectionType().toString())})));
            return;
        }
        try {
            Area area = selection.build();
            region.area().clearPoints();
            for (Vector3ic point : area.points()) {
                region.area().addPoint((Vector3ic)new Vector3i(point.x(), point.y(), point.z()));
            }
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SET_AREA_SUCCESS.arguments(new ComponentLike[]{Component.text((String)region.name())})));
        }
        catch (IncompleteAreaException e) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_INCOMPLETE_SELECTION.arguments(new ComponentLike[]{Component.text((String)e.getMessage())})));
        }
    }

    @Command(value="region|rg area select|sel <region>")
    @CommandDescription(value="Select the area a region spans.")
    public void onSelectArea(PlayerOrbisSession session, @Argument(value="region") Region region) {
        Selection selection = new Selection(region.area().getType());
        region.area().points().forEach(selection::addPoint);
        OrbisAPI.get().selectionManager().add(session.getUuid(), selection);
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SELECTED_AREA.arguments(new ComponentLike[]{Component.text((String)region.name())})));
    }

    @Command(value="region|rg area radius <region> <radius>")
    @CommandDescription(value="Set the radius of a spherical area of a region.")
    public void onSetAreaRadius(PlayerOrbisSession session, @Argument(value="region") Region region, @Argument(value="radius") double radius) {
        Area area = region.area();
        if (!(area instanceof SphericalArea)) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SET_AREA_RADIUS_NOT_SUPPORTED));
            return;
        }
        SphericalArea sphere = (SphericalArea)area;
        sphere.setRadius(radius);
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_SET_AREA_RADIUS_SUCCESS.arguments(new ComponentLike[]{Component.text((String)region.name())})));
    }

    @Command(value="region|rg remove|delete <region>")
    @CommandDescription(value="Completely remove a region and remove it from any worlds.")
    @Confirmation
    public void onRemove(OrbisSession session, @Argument(value="region") Region region) {
        boolean anySucceeded = OrbisAPI.get().removeRegion(region);
        if (anySucceeded) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_REMOVE_SUCCESS.arguments(new ComponentLike[]{Component.text((String)region.name())})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_REMOVE_FAILED.arguments(new ComponentLike[]{Component.text((String)region.name())})));
    }

    @Command(value="region|rg flag add <region> <flag> [value]")
    @CommandDescription(value="Add a flag to a region, optionally with a specific value.")
    public <T> void onFlagAdd(OrbisSession session, @Flag(value="groups", suggestions="groups") @Nullable String[] groups, @Argument(value="region") Region region, @Argument(value="flag") RegistryRegionFlag<?> flag, @Argument(value="value") @Nullable FlagValue<?> value) {
        if (groups == null) {
            region.addFlag(flag);
        } else {
            try {
                region.addGroupedFlag(flag, Arrays.stream(groups).map(FlagMemberGroup::valueOf).collect(Collectors.toSet()));
            }
            catch (IllegalArgumentException e) {
                session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_INVALID_GROUP));
                return;
            }
        }
        if (value != null) {
            RegistryRegionFlag<?> cast = flag;
            region.setFlag(cast, value.instance());
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_FLAG_ADDED.arguments(new ComponentLike[]{Component.text((String)flag.key().asString()), Component.text((String)region.name())})));
    }

    @Command(value="region|rg flag list <region>")
    @CommandDescription(value="List all flags set on a region.")
    public void onFlagList(OrbisSession session, @Argument(value="region") Region region) {
        String regionName = region.name();
        session.sendMessage(OrbisText.PREFIX.append(((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)regionName, (TextColor)OrbisText.SECONDARY_ORANGE))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY))));
        session.sendMessage((Component)Component.empty());
        this.displayFlags(session, region, -1);
    }

    @Command(value="region|rg flag remove <region> <flag>")
    @CommandDescription(value="Remove a flag from a region.")
    public void onFlagRemove(OrbisSession session, @Argument(value="region") Region region, @Argument(value="flag") RegistryRegionFlag<?> flag) {
        region.removeFlag(flag);
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_FLAG_REMOVED.arguments(new ComponentLike[]{Component.text((String)flag.key().asString()), Component.text((String)region.name())})));
    }

    @Command(value="region|rg flag set <region> <flag> <value>")
    @CommandDescription(value="Set the value of a flag on a region. This will add the flag if it does not already exist.")
    public <T> void onFlagSet(OrbisSession session, @Flag(value="groups", suggestions="groups") @Nullable String[] groups, @Argument(value="region") Region region, @Argument(value="flag") RegistryRegionFlag<?> flag, @Argument(value="value") @Greedy FlagValue<?> value) {
        if (!region.hasFlag(flag)) {
            this.onFlagAdd(session, groups, region, flag, value);
            return;
        }
        if (groups != null) {
            this.onFlagRemove(session, region, flag);
            this.onFlagAdd(session, groups, region, flag, value);
            return;
        }
        RegistryRegionFlag<?> cast = flag;
        region.setFlag(cast, value.instance());
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_FLAG_SET.arguments(new ComponentLike[]{Component.text((String)flag.key().asString()), Component.text((String)region.name())})));
    }

    @Command(value="region|rg setpriority <region> <priority>")
    @CommandDescription(value="Set the priority of a region. Flags in regions with higher priority take precedence.")
    public void onSetPriority(OrbisSession session, @Argument(value="region") Region region, @Argument(value="priority") int priority) {
        if (region.isGlobal()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PRIORITY_GLOBAL));
            return;
        }
        region.priority(priority);
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PRIORITY_SET.arguments(new ComponentLike[]{Component.text((String)region.name()), Component.text((String)String.valueOf(priority))})));
    }

    @Command(value="region|rg parent add <region> <parent>")
    @CommandDescription(value="Add a parent to a region. The region will inherit flags and members from the parent region. Flags or members on the child region still take precedence.")
    public void onAddParent(OrbisSession session, @Argument(value="region") Region region, @Argument(value="parent") Region parent) {
        if (region.isGlobal()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_GLOBAL));
            return;
        }
        if (region.equals(parent)) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_SELF));
            return;
        }
        if (region.parents().contains(parent)) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_ALREADY.arguments(new ComponentLike[]{Component.text((String)parent.name()), Component.text((String)region.name())})));
            return;
        }
        try {
            region.addParent(parent);
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_ADDED.arguments(new ComponentLike[]{Component.text((String)parent.name()), Component.text((String)region.name())})));
        }
        catch (IllegalArgumentException e) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_CIRCULAR));
        }
    }

    @Command(value="region|rg parent remove <region> <parent>")
    @CommandDescription(value="Removes a parent from a region.")
    public void onRemoveParent(OrbisSession session, @Argument(value="region") Region region, @Argument(value="parent") Region parent) {
        region.removeParent(parent);
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_PARENT_REMOVED.arguments(new ComponentLike[]{Component.text((String)parent.name()), Component.text((String)region.name())})));
    }

    @Command(value="region|rg world add <region> <world>")
    @CommandDescription(value="Adds a region to a world set. The region will affect the world it is added into.")
    public void addWorld(OrbisSession session, @Argument(value="region") Region region, @Argument(value="world") RegionisedWorld world) {
        if (region.isGlobal()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_GLOBAL));
            return;
        }
        if (world.add(region)) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_ADDED.arguments(new ComponentLike[]{Component.text((String)region.name()), Component.text((String)world.worldId().orElseThrow().asString())})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_ADD_FAILED.arguments(new ComponentLike[]{Component.text((String)region.name()), Component.text((String)world.worldId().orElseThrow().asString())})));
    }

    @Command(value="region|rg world remove <region> <world>")
    @CommandDescription(value="Removes a region from a world set.")
    public void removeWorld(OrbisSession session, @Argument(value="region") Region region, @Argument(value="world") RegionisedWorld world) {
        if (region.isGlobal()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_GLOBAL));
            return;
        }
        if (world.remove(region)) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_REMOVED.arguments(new ComponentLike[]{Component.text((String)region.name()), Component.text((String)world.worldId().orElseThrow().asString())})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_WORLD_REMOVE_FAILED.arguments(new ComponentLike[]{Component.text((String)region.name()), Component.text((String)world.worldId().orElseThrow().asString())})));
    }

    @Command(value="region|rg points add <region> <x> <y> <z>")
    @CommandDescription(value="Adds a point to a region's area.")
    public void onAddPos(OrbisSession session, @Argument(value="region") Region region, @Argument(value="x") int x, @Argument(value="y") int y, @Argument(value="z") int z) {
        if (!region.isGlobal() && region.area().addPoint((Vector3ic)new Vector3i(x, y, z))) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_POINT_ADDED.arguments(new ComponentLike[]{Component.text((int)x), Component.text((int)y), Component.text((int)z), Component.text((String)region.name())})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_POINT_ADD_FAILED.arguments(new ComponentLike[]{Component.text((String)region.name())})));
    }

    @Command(value="region|rg points list <region>")
    @CommandDescription(value="Lists all points in a region's area.")
    public void onListPoints(OrbisSession session, @Argument(value="region") Region region) {
        session.sendMessage(OrbisText.PREFIX.append(((TextComponent)Component.text((String)"Points in region ").append((Component)Component.text((String)region.name(), (TextColor)OrbisText.SECONDARY_ORANGE))).append((Component)Component.text((String)":"))));
        if (region.isGlobal()) {
            session.sendMessage((Component)Component.text((String)"  Global region - no area defined", (TextColor)NamedTextColor.GRAY));
            return;
        }
        Set<Vector3ic> points = region.area().points();
        if (points.isEmpty()) {
            session.sendMessage((Component)Component.text((String)"  No points defined for this region.", (TextColor)OrbisText.SECONDARY_RED));
            return;
        }
        int index = 1;
        for (Vector3ic point : points) {
            String pointStr = String.format("%d. [%d, %d, %d]", index++, point.x(), point.y(), point.z());
            String teleportCmd = String.format("/tp %d %d %d", point.x(), point.y(), point.z());
            BuildableComponent pointComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  " + pointStr).hoverEvent((HoverEventSource)HoverEvent.showText((Component)OrbisTranslations.GENERIC_CLICK_TO_TELEPORT))).clickEvent(ClickEvent.runCommand((String)teleportCmd))).append((Component)Component.space())).append((Component)Component.text((String)"["))).append((Component)Component.text((String)"TP", (TextColor)OrbisText.EREBOR_GREEN))).append((Component)Component.text((String)"]"))).build();
            session.sendMessage((Component)pointComponent);
        }
        session.sendMessage((Component)Component.empty());
    }

    @Command(value="region|rg member add <region> player <uuid>")
    @CommandDescription(value="Adds a player member to a region. This will match a player with the specified UUID.")
    public void onAddPlayer(OrbisSession session, @Argument(value="region") Region region, @Argument(value="uuid") UUID uuid) {
        region.addMember(new PlayerMember(uuid));
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PLAYER_ADDED.arguments(new ComponentLike[]{Component.text((String)uuid.toString()), Component.text((String)region.name())})));
    }

    @Command(value="region|rg member remove <region> player <uuid>")
    @CommandDescription(value="Removes a player member from a region.")
    public void onRemovePlayer(OrbisSession session, @Argument(value="region") Region region, @Argument(value="uuid") UUID uuid) {
        for (Member member : region.members()) {
            PlayerMember playerMember;
            if (!(member instanceof PlayerMember) || !(playerMember = (PlayerMember)member).playerId().equals(uuid)) continue;
            region.removeMember(member);
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PLAYER_REMOVED.arguments(new ComponentLike[]{Component.text((String)uuid.toString())})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PLAYER_NOT_FOUND));
    }

    @Command(value="region|rg member add <region> permission <permission>")
    @CommandDescription(value="Adds a permission member to a region. This will match players with the specified permission.")
    public void onAddPermission(OrbisSession session, @Argument(value="region") Region region, @Argument(value="permission") String permission) {
        region.addMember(new PermissionMember(permission));
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PERMISSION_ADDED.arguments(new ComponentLike[]{Component.text((String)permission), Component.text((String)region.name())})));
    }

    @Command(value="region|rg member remove <region> permission <permission>")
    @CommandDescription(value="Removes a permission member from a region.")
    public void onRemovePermission(OrbisSession session, @Argument(value="region") Region region, @Argument(value="permission") String permission) {
        for (Member member : region.members()) {
            PermissionMember permissionMember;
            if (!(member instanceof PermissionMember) || !(permissionMember = (PermissionMember)member).permission().equals(permission)) continue;
            region.removeMember(member);
            session.getAudience().sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PERMISSION_REMOVED.arguments(new ComponentLike[]{Component.text((String)permission)})));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_MEMBER_PERMISSION_NOT_FOUND));
    }

    @Command(value="region|rg info <region>")
    public void onInfo(OrbisSession session, @Argument(value="region") Region region) {
        String regionName = region.name();
        session.sendMessage(OrbisText.PREFIX.append(((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)regionName, (TextColor)OrbisText.SECONDARY_ORANGE))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY))));
        session.sendMessage(this.createClickableLine("Priority", String.valueOf(region.priority()), "/rg setpriority " + regionName + " ", "Click to set priority"));
        TextComponent parentsLine = Component.text((String)"Parents: ", (TextColor)OrbisText.EREBOR_GREEN);
        if (!region.isGlobal()) {
            parentsLine = parentsLine.append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"+", (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to add a parent region", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)("/rg parent add " + regionName + " ")))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
            session.sendMessage((Component)parentsLine);
            if (region.parents().isEmpty()) {
                session.sendMessage((Component)Component.text((String)"  \u00bb None", (TextColor)NamedTextColor.GRAY));
            } else {
                for (Region parent : region.parents()) {
                    Component parentLine = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u25b7 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)parent.name(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"-", (TextColor)NamedTextColor.RED).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Remove parent", (TextColor)OrbisText.SECONDARY_RED)))).clickEvent(ClickEvent.suggestCommand((String)("/rg parent remove " + regionName + " " + parent.name())))))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
                    session.sendMessage(parentLine);
                }
            }
        } else {
            session.sendMessage(parentsLine.append((Component)Component.text((String)"Global regions cannot have parents", (TextColor)NamedTextColor.GRAY)));
        }
        session.sendMessage((Component)Component.empty());
        session.sendMessage((Component)Component.text((String)"Area Information", (TextColor)OrbisText.EREBOR_GREEN));
        if (region.isGlobal()) {
            session.sendMessage((Component)Component.text((String)"  Global region - no area defined", (TextColor)NamedTextColor.GRAY));
        } else {
            Area area = region.area();
            String areaName = ((Key)OrbisRegistries.AREA_TYPE.getKey(area.getType()).orElseThrow()).asString();
            session.sendMessage(((TextComponent)Component.text((String)"  Type: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)areaName, (TextColor)NamedTextColor.WHITE))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Area type", (TextColor)OrbisText.EREBOR_GREEN))));
            Vector3ic min2 = area.getMin();
            Vector3ic max = area.getMax();
            session.sendMessage(((TextComponent)Component.text((String)"  Bounds: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)String.format("(%d, %d, %d) to (%d, %d, %d)", min2.x(), min2.y(), min2.z(), max.x(), max.y(), max.z()), (TextColor)NamedTextColor.WHITE))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"The minimum and maximum points of the area", (TextColor)OrbisText.EREBOR_GREEN))));
            long volume = Iterables.size((Iterable)area);
            session.sendMessage(((TextComponent)Component.text((String)"  Volume: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)String.format("%,d", volume), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" blocks", (TextColor)NamedTextColor.GRAY)));
            int pointCount = area.points().size();
            session.sendMessage(Component.text((String)"  Points: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)String.format("%,d", pointCount), (TextColor)NamedTextColor.WHITE)));
            if (session instanceof PlayerOrbisSession) {
                session.sendMessage((Component)Component.empty());
                session.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  [\u25b6] ", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"Set area", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to set a new area for this region", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)("/rg setarea " + regionName))))).append((Component)Component.text((String)" (select an area first with ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"/sel", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY)));
                session.sendMessage(Component.text((String)"  [\u25b6] ", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"Select area", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to select this region's area", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)("/rg selarea " + regionName)))));
                int centerX = (min2.x() + max.x()) / 2;
                int centerZ = (min2.z() + max.z()) / 2;
                int centerY = (min2.y() + max.y()) / 2;
                session.sendMessage(((TextComponent)Component.text((String)"  [\u25b6] ", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"Teleport to center", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to teleport to the center of this region", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.runCommand((String)("/tp @s " + centerX + " " + centerY + " " + centerZ))))).append(((TextComponent)Component.text((String)" (", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(centerX + ", " + centerY + ", " + centerZ), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY))));
            }
        }
        this.displayFlags(session, region, 5);
        Component membersLine = Component.text((String)"Members: ", (TextColor)OrbisText.EREBOR_GREEN).append(((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"+", (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to add a member", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)("/rg member add " + regionName + " "))))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY)));
        session.sendMessage(membersLine);
        for (Member member : region.members()) {
            Key typeName = (Key)OrbisRegistries.MEMBER_TYPE.getKey(member.getType()).orElseThrow();
            String value = "";
            if (member instanceof PermissionMember) {
                PermissionMember permissionMember = (PermissionMember)member;
                value = permissionMember.permission();
            } else if (member instanceof PlayerMember) {
                PlayerMember playerMember = (PlayerMember)member;
                value = playerMember.playerId().toString();
            }
            Component memberLine = ((TextComponent)((TextComponent)Component.text((String)("  " + typeName.asString() + ": "), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)value, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" ", (TextColor)NamedTextColor.GRAY))).append(((TextComponent)Component.text((String)"[-]", (TextColor)NamedTextColor.RED).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to remove this member", (TextColor)OrbisText.SECONDARY_RED)))).clickEvent(ClickEvent.suggestCommand((String)("/rg member remove " + regionName + " " + typeName.value() + " " + value))));
            session.sendMessage(memberLine);
        }
    }

    @Command(value="region|rg list")
    @CommandDescription(value="List all regions, optionally filtered by worlds.")
    public void onList(OrbisSession session, @Flag(value="worlds", suggestions="worlds") @Nullable String[] worlds) {
        Orbis orbis = OrbisAPI.get();
        HashSet<Region> regions = new HashSet<Region>();
        if (worlds != null && worlds.length > 0) {
            for (String worldKey : worlds) {
                RegionisedWorld world = orbis.getRegionisedWorld(Key.key((String)worldKey));
                regions.addAll(world.regions());
            }
        } else {
            regions.addAll(OrbisRegistries.REGIONS.getAll());
        }
        if (regions.isEmpty()) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.REGION_LIST_EMPTY));
            return;
        }
        session.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Regions:", (TextColor)OrbisText.EREBOR_GREEN)));
        for (Region region : regions) {
            session.sendMessage(Component.text((String)"- ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)region.name(), (TextColor)OrbisText.SECONDARY_ORANGE)));
        }
    }

    @Command(value="region|rg visualise|visualize")
    @CommandDescription(value="Toggle region boundary visualisation.")
    public void onVisualise(PlayerOrbisSession session) {
        UUID uuid;
        OrbisPlatform platform = (OrbisPlatform)OrbisAPI.get();
        boolean nowVisualising = !platform.isVisualising(uuid = session.getUuid());
        platform.setVisualising(uuid, nowVisualising);
        if (nowVisualising) {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.ENABLE_REGION_VISUALISATION));
        } else {
            session.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.DISABLE_REGION_VISUALISATION));
        }
    }

    @Suggestions(value="groups")
    public List<ComponentTooltipSuggestion> groupSuggestions(CommandContext<OrbisSession> context, CommandInput input) {
        return Arrays.stream(FlagMemberGroup.values()).map(fmg -> ComponentTooltipSuggestion.suggestion(fmg.name(), (Component)Component.text((String)fmg.description()))).toList();
    }

    @Suggestions(value="worlds")
    public List<Suggestion> worldSuggestions(CommandContext<OrbisSession> context, CommandInput input) {
        return OrbisAPI.get().getRegionisedWorlds().stream().map(rw -> Suggestion.suggestion(rw.worldId().orElseThrow().asString())).toList();
    }

    private Component createClickableLine(String label, String value, String command, String hoverText) {
        return Component.text((String)(label + ": "), (TextColor)OrbisText.EREBOR_GREEN).append(((TextComponent)Component.text((String)value, (TextColor)NamedTextColor.WHITE).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)hoverText, (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)command)));
    }

    private void displayFlags(OrbisSession session, Region region, int limit) {
        String regionName = region.name();
        Component flagsLine = Component.text((String)"Flags: ", (TextColor)OrbisText.EREBOR_GREEN).append(((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"List", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to list all flags", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.runCommand((String)("/rg flag list " + regionName))))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY))).append(((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)"+", (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to add a flag", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.suggestCommand((String)("/rg flag add " + regionName + " "))))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY))));
        session.sendMessage(flagsLine);
        HashMap flags = new HashMap();
        for (RegistryRegionFlag registryRegionFlag : OrbisRegistries.FLAGS) {
            region.getFlag(registryRegionFlag).ifPresent(mu -> {
                if (mu instanceof GroupedMutableRegionFlag) {
                    GroupedMutableRegionFlag grouped = (GroupedMutableRegionFlag)mu;
                    flags.put(flag, grouped.groups().stream().map(Enum::name).collect(Collectors.toSet()));
                } else {
                    flags.put(flag, Collections.emptySet());
                }
            });
        }
        if (flags.isEmpty()) {
            if (limit != 0) {
                session.sendMessage((Component)Component.text((String)"  No flags set.", (TextColor)NamedTextColor.GRAY));
            }
            return;
        }
        ArrayList flagEntries = new ArrayList(flags.entrySet());
        boolean bl = limit > 0 && flagEntries.size() > limit;
        int displayCount = bl ? limit - 1 : flagEntries.size();
        for (int i = 0; i < displayCount; ++i) {
            Map.Entry entry = (Map.Entry)flagEntries.get(i);
            RegistryRegionFlag registryFlag = (RegistryRegionFlag)entry.getKey();
            MutableRegionFlag flag = region.getFlag(registryFlag).orElseThrow();
            Set groups = (Set)entry.getValue();
            TextComponent flagName = Component.text((String)flag.key().asString(), (TextColor)NamedTextColor.WHITE);
            Optional<String> description = registryFlag.description();
            if (description.isPresent()) {
                flagName = flagName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)description.get(), (TextColor)NamedTextColor.WHITE)));
            }
            Component flagLine = ((TextComponent)((TextComponent)Component.text((String)"  ", (TextColor)NamedTextColor.GRAY).append((Component)flagName)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)flag.getValue().toString(), (TextColor)NamedTextColor.YELLOW));
            if (!groups.isEmpty()) {
                flagLine = flagLine.append((Component)Component.text((String)" (", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)String.join((CharSequence)", ", groups), (TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY));
            }
            flagLine = flagLine.append((Component)Component.space()).append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"\u270e", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to modify this flag", (TextColor)OrbisText.SECONDARY_ORANGE)))).clickEvent(ClickEvent.suggestCommand((String)("/rg flag set " + regionName + " " + flag.key().asString() + " ")))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
            flagLine = flagLine.append((Component)Component.space()).append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"-", (TextColor)NamedTextColor.RED).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to remove this flag", (TextColor)OrbisText.SECONDARY_RED)))).clickEvent(ClickEvent.suggestCommand((String)("/rg flag remove " + regionName + " " + flag.key().asString())))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
            session.sendMessage(flagLine);
        }
        if (bl) {
            int remaining = flagEntries.size() - displayCount;
            session.sendMessage(((TextComponent)Component.text((String)("  and " + remaining + " more..."), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to view all flags", (TextColor)OrbisText.EREBOR_GREEN)))).clickEvent(ClickEvent.runCommand((String)("/rg flag list " + regionName))));
        }
    }
}

