/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.context.CommandInput;
import org.empirewar.orbis.paper.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.paper.libs.cloud.suggestion.BlockingSuggestionProvider;
import org.empirewar.orbis.paper.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.registry.OrbisRegistries;

public final class RegionFlagParser<C>
implements ArgumentParser<C, RegistryRegionFlag<?>>,
BlockingSuggestionProvider<C> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull RegistryRegionFlag<?>> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        Optional<RegistryRegionFlag> regionFlag = OrbisRegistries.FLAGS.get(Key.key((String)input));
        return regionFlag.map(f -> {
            commandInput.readString();
            return ArgumentParseResult.success(f);
        }).orElseGet(() -> ArgumentParseResult.failure(new RegionFlagParserException(input, commandContext)));
    }

    @Override
    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return OrbisRegistries.FLAGS.getAll().stream().map(flag -> {
            Optional<String> description = flag.description();
            if (description.isPresent()) {
                return ComponentTooltipSuggestion.suggestion(flag.key().asString(), (Component)Component.text((String)description.get(), (TextColor)NamedTextColor.WHITE));
            }
            return Suggestion.suggestion(flag.key().asString());
        }).toList();
    }

    public static final class RegionFlagParserException
    extends ParserException {
        public RegionFlagParserException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(RegionFlagParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_REGION_FLAG_NOT_FOUND, CaptionVariable.of("input", input));
        }
    }
}

