/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser.registry;

import java.util.Optional;
import java.util.stream.Collectors;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.command.parser.registry.RegistryMapper;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.context.CommandInput;
import org.empirewar.orbis.paper.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.paper.libs.cloud.suggestion.BlockingSuggestionProvider;
import org.empirewar.orbis.registry.OrbisRegistry;

public final class RegistryValueParser<C, R, K>
implements ArgumentParser<C, R>,
BlockingSuggestionProvider.Strings<C> {
    private final OrbisRegistry<R, K> registry;
    private final RegistryMapper<String, K> keyMapper;

    public RegistryValueParser(OrbisRegistry<R, K> registry, RegistryMapper<String, K> keyMapper) {
        this.registry = registry;
        this.keyMapper = keyMapper;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull R> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        Optional<R> registered = this.registry.get(this.keyMapper.map(commandInput.peekString()));
        if (registered.isPresent()) {
            commandInput.readString();
            return ArgumentParseResult.success(registered.get());
        }
        return ArgumentParseResult.failure(new RegistryValueParserException(input, this.registry, commandContext));
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return this.registry.getKeys().stream().map(this.keyMapper::reverse).collect(Collectors.toSet());
    }

    public static final class RegistryValueParserException
    extends ParserException {
        private final String input;

        public RegistryValueParserException(@NonNull String input, @NonNull OrbisRegistry<?, ?> registry, @NonNull CommandContext<?> context) {
            super(RegistryValueParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_VALUE_NOT_FOUND, CaptionVariable.of("input", input), CaptionVariable.of("registry", registry.key().asString()));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

