/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.flag;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.flag.RegistryRegionFlag;

final class RegionFlagBuilder<T>
implements RegistryRegionFlag.Builder<T> {
    private Key key;
    private String description;
    private Supplier<T> defaultValue;
    private Codec<T> codec;

    RegionFlagBuilder() {
    }

    @Override
    public RegistryRegionFlag<T> build() {
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"Key cannot be empty");
        Preconditions.checkState((this.defaultValue != null ? 1 : 0) != 0, (Object)"Value cannot be empty");
        Preconditions.checkState((this.codec != null ? 1 : 0) != 0, (Object)"Value Codec be empty");
        return new RegistryRegionFlag<T>(this.key, this.description, this.defaultValue, this.codec);
    }

    @Override
    public RegistryRegionFlag.Builder<T> key(Key key) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.key = key;
        return this;
    }

    @Override
    public RegistryRegionFlag.Builder<T> description(String description) {
        Objects.requireNonNull(description, "Description cannot be null");
        this.description = description;
        return this;
    }

    @Override
    public RegistryRegionFlag.Builder<T> defaultValue(Supplier<T> value) {
        Objects.requireNonNull(value, "Value cannot be null");
        this.defaultValue = value;
        return this;
    }

    @Override
    public RegistryRegionFlag.Builder<T> codec(Codec<T> codec) {
        Objects.requireNonNull(codec, "Codec cannot be null");
        this.codec = codec;
        return this;
    }
}

