/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.migrations.worldguard;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.member.FlagMemberGroup;
import org.empirewar.orbis.region.Region;

@FunctionalInterface
public interface FlagTransformer {
    public static final FlagTransformer DEFAULT = (audience, region, flag, orbisRegion, orbisFlag) -> {
        boolean group;
        boolean bl = group = flag.getName().equals("entry") || flag.getName().equals("exit");
        if (group) {
            orbisRegion.addGroupedFlag(orbisFlag, Set.of(FlagMemberGroup.NONMEMBER));
        } else {
            orbisRegion.addFlag(orbisFlag);
        }
        if (flag instanceof StateFlag) {
            StateFlag stateFlag = (StateFlag)flag;
            StateFlag.State state = (StateFlag.State)region.getFlag((Flag)stateFlag);
            if (flag.getName().equals("invincible")) {
                if (state == StateFlag.State.ALLOW) {
                    orbisRegion.setFlag(orbisFlag, false);
                } else {
                    orbisRegion.setFlag(orbisFlag, true);
                }
            } else {
                switch (state) {
                    case DENY: {
                        orbisRegion.setFlag(orbisFlag, false);
                        break;
                    }
                    case ALLOW: {
                        orbisRegion.setFlag(orbisFlag, true);
                    }
                }
            }
            audience.sendMessage((Component)Component.text((String)("Processed state flag '" + flag.getName() + "' with state '" + String.valueOf(state) + "'..."), (TextColor)NamedTextColor.LIGHT_PURPLE));
        }
    };

    public void transform(Audience var1, ProtectedRegion var2, Flag<?> var3, Region var4, RegistryRegionFlag<?> var5);
}

