/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.migrations.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegionFlag;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.member.PlayerMember;
import org.empirewar.orbis.migrations.worldguard.FlagTransformer;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.world.RegionisedWorld;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class WorldGuardMigrator {
    private static final Map<String, RegistryRegionFlag<?>> FLAG_MAPPINGS = new HashMap<String, RegistryRegionFlag<Boolean>>(Map.of("block-break", DefaultFlags.CAN_BREAK, "block-place", DefaultFlags.CAN_PLACE, "pvp", DefaultFlags.CAN_PVP, "damage-animals", DefaultFlags.DAMAGEABLE_ENTITIES, "fall-damage", DefaultFlags.FALL_DAMAGE, "item-drop", DefaultFlags.CAN_DROP_ITEM, "item-pickup", DefaultFlags.CAN_PICKUP_ITEM, "chest-access", DefaultFlags.BLOCK_INVENTORY_ACCESS, "use", DefaultFlags.TRIGGER_REDSTONE, "coral-fade", DefaultFlags.CORAL_DECAY));
    private static final Map<RegionFlag<?>, FlagTransformer> TRANSFORMERS;

    public WorldGuardMigrator(Audience actor) {
        WorldGuard instance = WorldGuard.getInstance();
        Audience audience = Audience.audience((Audience[])new Audience[]{actor, Bukkit.getConsoleSender()});
        int errors = 0;
        int worldIndex = 1;
        for (World world : Bukkit.getWorlds()) {
            audience.sendMessage((Component)Component.text((String)("Processing worlds (" + worldIndex + "/" + Bukkit.getWorlds().size() + "): " + world.getName()), (TextColor)NamedTextColor.GREEN));
            RegionManager regionManager = instance.getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
            RegionisedWorld regionisedWorld = OrbisAPI.get().getRegionisedWorld(world.key());
            for (ProtectedRegion protectedRegion : regionManager.getRegions().values()) {
                Region orbisRegion;
                Optional possibleExisting = OrbisRegistries.REGIONS.get(protectedRegion.getId());
                if (possibleExisting.isPresent()) {
                    regionisedWorld.add((Region)possibleExisting.get());
                    continue;
                }
                EncompassingArea area = protectedRegion.getType() == RegionType.POLYGON ? new PolygonArea() : new CuboidArea();
                audience.sendMessage((Component)Component.text((String)("Processing region " + protectedRegion.getId() + "..."), (TextColor)NamedTextColor.YELLOW));
                Region region = orbisRegion = protectedRegion.getId().equals("__global__") ? regionisedWorld.getByName(world.key().asString()).orElseThrow() : new Region(protectedRegion.getId(), area);
                if (!orbisRegion.isGlobal()) {
                    if (area instanceof PolygonArea) {
                        for (BlockVector2 point : protectedRegion.getPoints()) {
                            area.addPoint((Vector3ic)new Vector3i(point.getBlockX(), 0, point.getBlockZ()));
                        }
                    } else {
                        BlockVector3 min2 = protectedRegion.getMinimumPoint();
                        BlockVector3 max = protectedRegion.getMaximumPoint();
                        orbisRegion.area().addPoint((Vector3ic)new Vector3i(min2.getX(), min2.getY(), min2.getZ()));
                        orbisRegion.area().addPoint((Vector3ic)new Vector3i(max.getX(), max.getY(), max.getZ()));
                    }
                    orbisRegion.priority(protectedRegion.getPriority());
                }
                for (Flag flag : protectedRegion.getFlags().keySet()) {
                    String name = flag.getName();
                    RegistryRegionFlag<?> orbisFlag = FLAG_MAPPINGS.get(name);
                    if (orbisFlag == null) {
                        audience.sendMessage((Component)Component.text((String)("Unable to find flag '" + name + "'!"), (TextColor)NamedTextColor.RED));
                        ++errors;
                        continue;
                    }
                    FlagTransformer transformer = TRANSFORMERS.getOrDefault(orbisFlag, FlagTransformer.DEFAULT);
                    transformer.transform(audience, protectedRegion, flag, orbisRegion, orbisFlag);
                }
                regionisedWorld.add(orbisRegion);
                OrbisRegistries.REGIONS.register(orbisRegion.key(), orbisRegion);
                audience.sendMessage((Component)Component.text((String)("Added region '" + orbisRegion.name() + "'."), (TextColor)NamedTextColor.GREEN));
            }
            for (ProtectedRegion protectedRegion : regionManager.getRegions().values()) {
                Optional<Region> orbisRegion = regionisedWorld.getByName(protectedRegion.getId());
                if (orbisRegion.isEmpty()) continue;
                ProtectedRegion parent = protectedRegion.getParent();
                if (parent != null) {
                    Optional<Region> orbisParentRegion = regionisedWorld.getByName(parent.getId());
                    if (orbisParentRegion.isEmpty()) {
                        audience.sendMessage((Component)Component.text((String)("Unable to find parent '" + parent.getId() + "' for region '" + protectedRegion.getId() + "'."), (TextColor)NamedTextColor.RED));
                        ++errors;
                        continue;
                    }
                    orbisRegion.get().addParent(orbisParentRegion.get());
                    audience.sendMessage((Component)Component.text((String)("Added parent '" + parent.getId() + "' to '" + protectedRegion.getId() + "'."), (TextColor)NamedTextColor.GREEN));
                }
                for (UUID uniqueId : protectedRegion.getMembers().getUniqueIds()) {
                    orbisRegion.get().addMember(new PlayerMember(uniqueId));
                }
            }
            for (Region region : regionisedWorld.regions()) {
                if (region.query(RegionQuery.Flag.builder(DefaultFlags.CAN_BREAK)).result().isEmpty()) {
                    region.addFlag(DefaultFlags.CAN_BREAK).setValue(false);
                }
                if (!region.query(RegionQuery.Flag.builder(DefaultFlags.CAN_PLACE)).result().isEmpty()) continue;
                region.addFlag(DefaultFlags.CAN_PLACE).setValue(false);
            }
            ++worldIndex;
        }
        audience.sendMessage((Component)Component.text((String)"Migration complete.", (TextColor)NamedTextColor.GREEN));
        if (errors > 0) {
            audience.sendMessage(Component.text((String)"WARNING: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)("Migration completed with " + errors + " errors. Check logs for more information."), (TextColor)NamedTextColor.YELLOW)));
        }
        audience.sendMessage((Component)Component.text((String)"What's next?", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        audience.sendMessage((Component)Component.text((String)" 1) Stop your server.", (TextColor)NamedTextColor.GRAY));
        audience.sendMessage((Component)Component.text((String)" 2) Remove the WorldGuard plugin.", (TextColor)NamedTextColor.GRAY));
        audience.sendMessage((Component)Component.text((String)" 3) Start your server again. Welcome to Orbis!", (TextColor)NamedTextColor.GRAY));
        audience.sendMessage((Component)Component.text((String)"Make sure to check for any migration errors. Most should be harmless, but you may need to adjust some flags.", (TextColor)NamedTextColor.YELLOW));
    }

    static {
        FLAG_MAPPINGS.putAll(Map.of("leaf-decay", DefaultFlags.LEAF_DECAY, "block-trampling", DefaultFlags.BLOCK_TRAMPLE, "entity-painting-destroy", DefaultFlags.CAN_DESTROY_PAINTING, "entity-item-frame-destroy", DefaultFlags.CAN_DESTROY_ITEM_FRAME, "item-frame-rotation", DefaultFlags.ITEM_FRAME_ROTATE, "mushroom-growth", DefaultFlags.GROWABLE_BLOCKS, "vine-growth", DefaultFlags.GROWABLE_BLOCKS, "rock-growth", DefaultFlags.GROWABLE_BLOCKS));
        FLAG_MAPPINGS.putAll(Map.of("crop-growth", DefaultFlags.GROWABLE_BLOCKS, "vehicle-destroy", DefaultFlags.CAN_DESTROY_VEHICLE, "entry", DefaultFlags.CAN_ENTER, "invincible", DefaultFlags.CAN_TAKE_MOB_DAMAGE_SOURCES, "fire-spread", DefaultFlags.FIRE_SPREAD, "time-lock", DefaultFlags.TIME, "greeting", DefaultFlags.ENTRY_MESSAGE, "farewell", DefaultFlags.EXIT_MESSAGE));
        FLAG_MAPPINGS.putAll(Map.of("pistons", DefaultFlags.ACTIVATE_PISTONS));
        TRANSFORMERS = Map.of(DefaultFlags.DAMAGEABLE_ENTITIES, (audience, region, flag, orbisRegion, orbisFlag) -> {
            StateFlag stateFlag = (StateFlag)flag;
            StateFlag.State value = (StateFlag.State)region.getFlag((Flag)stateFlag);
            MutableRegionFlag existing = orbisRegion.getFlag(orbisFlag).orElse(null);
            if (existing == null) {
                existing = orbisFlag.asMutable();
            }
            if (value == StateFlag.State.ALLOW) {
                if (flag.getName().equals("damage-animals")) {
                    List<Key> valid = Registry.ENTITY_TYPE.stream().filter(EntityType::isAlive).map(Keyed::key).toList();
                    ((List)existing.getValue()).addAll(valid);
                }
            } else if (!orbisRegion.hasFlag(orbisFlag)) {
                orbisRegion.addFlag(orbisFlag);
            }
        }, DefaultFlags.GROWABLE_BLOCKS, (audience, region, flag, orbisRegion, orbisFlag) -> {
            if (!orbisRegion.hasFlag(orbisFlag)) {
                orbisRegion.addFlag(orbisFlag);
            }
            MutableRegionFlag mu = orbisRegion.getFlag(orbisFlag).orElseThrow();
            StateFlag stateFlag = (StateFlag)flag;
            if (region.getFlag((Flag)stateFlag) != StateFlag.State.ALLOW) {
                return;
            }
            List value = (List)mu.getValue();
            switch (flag.getName()) {
                case "mushroom-growth": {
                    value.add(Material.RED_MUSHROOM.key());
                    value.add(Material.BROWN_MUSHROOM.key());
                    value.add(Material.CRIMSON_FUNGUS.key());
                    value.add(Material.WARPED_FUNGUS.key());
                    break;
                }
                case "vine-growth": {
                    value.add(Material.VINE.key());
                    value.add(Material.CAVE_VINES.key());
                    value.add(Material.TWISTING_VINES.key());
                    value.add(Material.WEEPING_VINES.key());
                    break;
                }
                case "rock-growth": {
                    value.add(Material.DRIPSTONE_BLOCK.key());
                    break;
                }
                case "crop-growth": {
                    for (Material cropsValue : Tag.CROPS.getValues()) {
                        value.add(cropsValue.key());
                    }
                    break;
                }
            }
        });
    }
}

