/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.caffeine;

import org.empirewar.orbis.paper.libs.caffeine.AsyncCacheLoader;
import org.empirewar.orbis.paper.libs.caffeine.Caffeine;
import org.empirewar.orbis.paper.libs.caffeine.LocalCacheFactory;
import org.empirewar.orbis.paper.libs.caffeine.Node;
import org.empirewar.orbis.paper.libs.caffeine.Pacer;
import org.empirewar.orbis.paper.libs.caffeine.SILMW;
import org.empirewar.orbis.paper.libs.caffeine.Scheduler;
import org.empirewar.orbis.paper.libs.caffeine.Ticker;
import org.empirewar.orbis.paper.libs.caffeine.WriteOrderDeque;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;

class SILMWW<K, V>
extends SILMW<K, V> {
    static final LocalCacheFactory FACTORY = SILMWW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SILMWW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

