/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.annotations.extractor;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.paper.libs.cloud.annotations.AnnotationParser;
import org.empirewar.orbis.paper.libs.cloud.annotations.DescriptionMapper;
import org.empirewar.orbis.paper.libs.cloud.annotations.Flag;
import org.empirewar.orbis.paper.libs.cloud.annotations.descriptor.FlagDescriptor;
import org.empirewar.orbis.paper.libs.cloud.annotations.descriptor.ImmutableFlagDescriptor;
import org.empirewar.orbis.paper.libs.cloud.annotations.extractor.FlagExtractor;
import org.empirewar.orbis.paper.libs.cloud.permission.Permission;

@API(status=API.Status.INTERNAL, consumers={"org.empirewar.orbis.paper.libs.cloud.annotations.*"})
public final class FlagExtractorImpl
implements FlagExtractor {
    private final AnnotationParser<?> annotationParser;
    private final DescriptionMapper descriptionMapper;

    private static @Nullable String nullIfEmpty(@NonNull String string) {
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public FlagExtractorImpl(@NonNull AnnotationParser<?> annotationParser) {
        this.annotationParser = annotationParser;
        this.descriptionMapper = this.annotationParser::mapDescription;
    }

    @Override
    public @NonNull Collection<@NonNull FlagDescriptor> extractFlags(@NonNull Method method) {
        LinkedList<FlagDescriptor> flags = new LinkedList<FlagDescriptor>();
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(Flag.class)) continue;
            Flag flag = parameter.getAnnotation(Flag.class);
            String flagName = this.annotationParser.processString(flag.value());
            String name = flagName.equals("__INFERRED_ARGUMENT_NAME__") ? parameter.getName() : flagName;
            ImmutableFlagDescriptor flagDescriptor = FlagDescriptor.builder().parameter(parameter).name(name).description(this.descriptionMapper.map(flag.description())).aliases(this.annotationParser.processStrings(Arrays.asList(flag.aliases()))).permission(Permission.of(this.annotationParser.processString(flag.permission()))).repeatable(flag.repeatable()).parserName(FlagExtractorImpl.nullIfEmpty(this.annotationParser.processString(flag.parserName()))).suggestions(FlagExtractorImpl.nullIfEmpty(this.annotationParser.processString(flag.suggestions()))).build();
            flags.add(flagDescriptor);
        }
        return flags;
    }
}

