/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.bukkit;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.CommandManager;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitParserParameters;
import org.empirewar.orbis.paper.libs.cloud.bukkit.CloudBukkitCapabilities;
import org.empirewar.orbis.paper.libs.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import org.empirewar.orbis.paper.libs.cloud.bukkit.annotation.specifier.DefaultNamespace;
import org.empirewar.orbis.paper.libs.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import org.empirewar.orbis.paper.libs.cloud.bukkit.data.MultipleEntitySelector;
import org.empirewar.orbis.paper.libs.cloud.bukkit.data.MultiplePlayerSelector;
import org.empirewar.orbis.paper.libs.cloud.bukkit.internal.CraftBukkitReflection;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.BlockPredicateParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.EnchantmentParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.ItemStackParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.ItemStackPredicateParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.MaterialParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.NamespacedKeyParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.OfflinePlayerParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.PlayerParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.WorldParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.location.Location2DParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.location.LocationParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import org.empirewar.orbis.paper.libs.cloud.parser.ParserParameters;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

