/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.bukkit.parser;

import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitCaptionKeys;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitCommandContextKeys;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.paper.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.context.CommandInput;
import org.empirewar.orbis.paper.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.paper.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.paper.libs.cloud.suggestion.BlockingSuggestionProvider;

public final class OfflinePlayerParser<C>
implements ArgumentParser<C, OfflinePlayer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, OfflinePlayer> offlinePlayerParser() {
        return ParserDescriptor.of(new OfflinePlayerParser<C>(), OfflinePlayer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, OfflinePlayer> offlinePlayerComponent() {
        return CommandComponent.builder().parser(OfflinePlayerParser.offlinePlayerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<OfflinePlayer> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        OfflinePlayer player;
        String input = commandInput.readString();
        if (input.length() > 16) {
            return ArgumentParseResult.failure(new OfflinePlayerParseException(input, commandContext));
        }
        try {
            player = Bukkit.getOfflinePlayer((String)input);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new OfflinePlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        CommandSender bukkit = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        return Bukkit.getOnlinePlayers().stream().filter(player -> !(bukkit instanceof Player) || ((Player)bukkit).canSee(player)).map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    public static final class OfflinePlayerParseException
    extends ParserException {
        private final String input;

        public OfflinePlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(OfflinePlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_OFFLINEPLAYER, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

