/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.registry.lifecycle;

import org.empirewar.orbis.registry.lifecycle.RegistryLifecycle;

public final class RegistryLifecycles {
    private static final RegistryLifecycle LOADING = new RegistryLifecycle(){

        @Override
        public boolean hasExpired(RegistryLifecycle current) {
            return current == ACTIVE || current == FROZEN;
        }

        @Override
        public String name() {
            return "loading";
        }
    };
    private static final RegistryLifecycle ACTIVE = new RegistryLifecycle(){

        @Override
        public boolean hasExpired(RegistryLifecycle current) {
            return current == FROZEN;
        }

        @Override
        public String name() {
            return "active";
        }
    };
    private static final RegistryLifecycle FROZEN = new RegistryLifecycle(){

        @Override
        public boolean hasExpired(RegistryLifecycle current) {
            return false;
        }

        @Override
        public String name() {
            return "frozen";
        }
    };

    private RegistryLifecycles() {
    }

    public static RegistryLifecycle loading() {
        return LOADING;
    }

    public static RegistryLifecycle active() {
        return ACTIVE;
    }

    public static RegistryLifecycle frozen() {
        return FROZEN;
    }
}

