/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser.registry;

import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.command.parser.registry.RegistryMapper;
import org.empirewar.orbis.registry.OrbisRegistry;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class RegistryValueParser<C, R, K>
implements ArgumentParser<C, R>,
BlockingSuggestionProvider.Strings<C> {
    private final OrbisRegistry<R, K> registry;
    private final RegistryMapper<String, K> keyMapper;

    public RegistryValueParser(OrbisRegistry<R, K> registry, RegistryMapper<String, K> keyMapper) {
        this.registry = registry;
        this.keyMapper = keyMapper;
    }

    public @NonNull ArgumentParseResult<@NonNull R> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        Optional<R> registered = this.registry.get(this.keyMapper.map(commandInput.peekString()));
        if (registered.isPresent()) {
            commandInput.readString();
            return ArgumentParseResult.success(registered.get());
        }
        return ArgumentParseResult.failure((Throwable)((Object)new RegistryValueParserException(input, this.registry, commandContext)));
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return this.registry.getKeys().stream().map(this.keyMapper::reverse).collect(Collectors.toSet());
    }

    public static final class RegistryValueParserException
    extends ParserException {
        private final String input;

        public RegistryValueParserException(@NonNull String input, @NonNull OrbisRegistry<?, ?> registry, @NonNull CommandContext<?> context) {
            super(RegistryValueParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_VALUE_NOT_FOUND, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input), CaptionVariable.of((String)"registry", (String)registry.key().asString())});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

