/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.modded.util;

import net.kyori.adventure.key.Keyed;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;
import org.jetbrains.annotations.Nullable;

public final class FlagActions {
    private FlagActions() {
        throw new UnsupportedOperationException();
    }

    public static boolean shouldPreventBlockAction(Level level, BlockPos pos, @Nullable Player player, RegistryRegionFlag<Boolean> flag) {
        if (pos == null) {
            return false;
        }
        RegionisedWorld world = OrbisAPI.get().getRegionisedWorld(((Keyed)level.dimension()).key());
        if (world == null) {
            return false;
        }
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.getUUID());
        }
        return world.query(RegionQuery.Position.at(pos.getX(), pos.getY(), pos.getZ())).query(builder).result().orElse(true) == false;
    }

    public static boolean shouldPreventEntityAction(Entity entity, RegistryRegionFlag<Boolean> flag) {
        return FlagActions.shouldPreventEntityAction(entity, entity, flag);
    }

    public static boolean shouldPreventEntityAction(Entity entity, @Nullable Entity player, RegistryRegionFlag<Boolean> flag) {
        BlockPos location;
        RegionisedWorld world = OrbisAPI.get().getRegionisedWorld(((Keyed)entity.level().dimension()).key());
        if (world == null) {
            return false;
        }
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.getUUID());
        }
        return world.query(RegionQuery.Position.at((location = entity.blockPosition()).getX(), location.getY(), location.getZ())).query(builder).result().orElse(true) == false;
    }
}

