/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.region.RegionType;
import org.empirewar.orbis.world.RegionisedWorldSet;

public final class GlobalRegion
extends Region {
    public static final MapCodec<GlobalRegion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Region::name), (App)MutableRegionFlag.TYPE_CODEC.listOf().fieldOf("flags").forGetter(r -> r.flags.values().stream().toList())).apply((Applicative)instance, GlobalRegion::new));

    public GlobalRegion(RegionisedWorldSet set) {
        super(set.worldId().orElseThrow().asString(), null);
        this.priority(1);
    }

    public GlobalRegion(String name) {
        super(name, null);
        this.priority(1);
    }

    private GlobalRegion(String name, List<MutableRegionFlag<?>> flags) {
        super(name, null);
        this.priority(1);
        flags.forEach(mu -> this.flags.put(mu.key(), mu));
    }

    @Override
    public Area area() {
        throw new IllegalStateException("Cannot access area for global region");
    }

    @Override
    public Set<Region> parents() {
        throw new IllegalStateException("Cannot access parents for global region");
    }

    @Override
    public void addParent(Region region) {
        throw new IllegalStateException("Cannot access parents for global region");
    }

    @Override
    public void removeParent(Region region) {
        throw new IllegalStateException("Cannot access parents for global region");
    }

    @Override
    public RegionType<?> getType() {
        return RegionType.GLOBAL;
    }
}

