/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

public final class RegionFlagParser<C>
implements ArgumentParser<C, RegistryRegionFlag<?>>,
BlockingSuggestionProvider<C> {
    public @NonNull ArgumentParseResult<@NonNull RegistryRegionFlag<?>> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        Optional<RegistryRegionFlag> regionFlag = OrbisRegistries.FLAGS.get(Key.key((String)input));
        return regionFlag.map(f -> {
            commandInput.readString();
            return ArgumentParseResult.success((Object)f);
        }).orElseGet(() -> ArgumentParseResult.failure((Throwable)((Object)new RegionFlagParserException(input, commandContext))));
    }

    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return OrbisRegistries.FLAGS.getAll().stream().map(flag -> {
            Optional<String> description = flag.description();
            if (description.isPresent()) {
                return ComponentTooltipSuggestion.suggestion((String)flag.key().asString(), (Component)Component.text((String)description.get(), (TextColor)NamedTextColor.WHITE));
            }
            return Suggestion.suggestion((String)flag.key().asString());
        }).toList();
    }

    public static final class RegionFlagParserException
    extends ParserException {
        public RegionFlagParserException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(RegionFlagParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_REGION_FLAG_NOT_FOUND, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }
}

